/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.nio.netty.internal.utils;

import codegurushadow.io.netty.channel.Channel;
import codegurushadow.io.netty.channel.ChannelFactory;
import codegurushadow.io.netty.channel.EventLoopGroup;
import codegurushadow.io.netty.channel.ReflectiveChannelFactory;
import codegurushadow.io.netty.channel.epoll.EpollEventLoopGroup;
import codegurushadow.io.netty.channel.epoll.EpollSocketChannel;
import codegurushadow.io.netty.channel.nio.NioEventLoopGroup;
import codegurushadow.io.netty.channel.socket.nio.NioSocketChannel;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.nio.netty.internal.DelegatingEventLoopGroup;
import codegurushadow.software.amazon.awssdk.utils.FunctionalUtils;
import java.util.HashMap;
import java.util.Map;

@SdkInternalApi
public final class SocketChannelResolver {
    private static final Map<String, String> KNOWN_EL_GROUPS = new HashMap<String, String>();

    private SocketChannelResolver() {
    }

    public static ChannelFactory<? extends Channel> resolveSocketChannelFactory(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof DelegatingEventLoopGroup) {
            return SocketChannelResolver.resolveSocketChannelFactory(((DelegatingEventLoopGroup)eventLoopGroup).getDelegate());
        }
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            return NioSocketChannel::new;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel::new;
        }
        String socketFqcn = KNOWN_EL_GROUPS.get(eventLoopGroup.getClass().getName());
        if (socketFqcn == null) {
            throw new IllegalArgumentException("Unknown event loop group : " + eventLoopGroup.getClass());
        }
        return FunctionalUtils.invokeSafely(() -> new ReflectiveChannelFactory(Class.forName(socketFqcn)));
    }

    static {
        KNOWN_EL_GROUPS.put("codegurushadow.io.netty.channel.kqueue.KQueueEventLoopGroup", "codegurushadow.io.netty.channel.kqueue.KQueueSocketChannel");
        KNOWN_EL_GROUPS.put("codegurushadow.io.netty.channel.oio.OioEventLoopGroup", "codegurushadow.io.netty.channel.socket.oio.OioSocketChannel");
    }
}

