/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.protocols.json;

import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.annotations.SdkTestInternalApi;
import codegurushadow.software.amazon.awssdk.awscore.exception.AwsServiceException;
import codegurushadow.software.amazon.awssdk.core.SdkPojo;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientOption;
import codegurushadow.software.amazon.awssdk.core.http.HttpResponseHandler;
import codegurushadow.software.amazon.awssdk.core.http.MetricCollectingHttpResponseHandler;
import codegurushadow.software.amazon.awssdk.core.metrics.CoreMetric;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallLocation;
import codegurushadow.software.amazon.awssdk.core.traits.TimestampFormatTrait;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullResponse;
import codegurushadow.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import codegurushadow.software.amazon.awssdk.protocols.core.OperationInfo;
import codegurushadow.software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import codegurushadow.software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import codegurushadow.software.amazon.awssdk.protocols.json.AwsJsonProtocolMetadata;
import codegurushadow.software.amazon.awssdk.protocols.json.DefaultJsonContentTypeResolver;
import codegurushadow.software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import codegurushadow.software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import codegurushadow.software.amazon.awssdk.protocols.json.StructuredJsonFactory;
import codegurushadow.software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.AwsStructuredPlainJsonFactory;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.marshall.JsonProtocolMarshallerBuilder;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.AwsJsonErrorMessageParser;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.AwsJsonProtocolErrorUnmarshaller;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.AwsJsonResponseHandler;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonProtocolUnmarshaller;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonResponseHandler;
import codegurushadow.software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@SdkProtectedApi
public abstract class BaseAwsJsonProtocolFactory {
    protected static final JsonContentTypeResolver AWS_JSON = new DefaultJsonContentTypeResolver("application/x-amz-json-");
    private final AwsJsonProtocolMetadata protocolMetadata;
    private final List<ExceptionMetadata> modeledExceptions;
    private final Supplier<SdkPojo> defaultServiceExceptionSupplier;
    private final String customErrorCodeFieldName;
    private final SdkClientConfiguration clientConfiguration;
    private final JsonProtocolUnmarshaller protocolUnmarshaller;

    protected BaseAwsJsonProtocolFactory(Builder<?> builder) {
        this.protocolMetadata = ((Builder)builder).protocolMetadata.build();
        this.modeledExceptions = Collections.unmodifiableList(((Builder)builder).modeledExceptions);
        this.defaultServiceExceptionSupplier = ((Builder)builder).defaultServiceExceptionSupplier;
        this.customErrorCodeFieldName = ((Builder)builder).customErrorCodeFieldName;
        this.clientConfiguration = ((Builder)builder).clientConfiguration;
        this.protocolUnmarshaller = JsonProtocolUnmarshaller.builder().parser(JsonNodeParser.builder().jsonFactory(this.getSdkFactory().getJsonFactory()).build()).defaultTimestampFormats(this.getDefaultTimestampFormats()).build();
    }

    public final <T extends SdkPojo> HttpResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Supplier<SdkPojo> pojoSupplier) {
        return this.createResponseHandler(operationMetadata, (SdkHttpFullResponse r) -> (SdkPojo)pojoSupplier.get());
    }

    public final <T extends SdkPojo> HttpResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Function<SdkHttpFullResponse, SdkPojo> pojoSupplier) {
        return this.timeUnmarshalling(new AwsJsonResponseHandler(new JsonResponseHandler(this.protocolUnmarshaller, pojoSupplier, operationMetadata.hasStreamingSuccessResponse(), operationMetadata.isPayloadJson())));
    }

    public final HttpResponseHandler<AwsServiceException> createErrorResponseHandler(JsonOperationMetadata errorResponseMetadata) {
        return this.timeUnmarshalling(AwsJsonProtocolErrorUnmarshaller.builder().jsonProtocolUnmarshaller(this.protocolUnmarshaller).exceptions(this.modeledExceptions).errorCodeParser(this.getSdkFactory().getErrorCodeParser(this.customErrorCodeFieldName)).errorMessageParser(AwsJsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER).jsonFactory(this.getSdkFactory().getJsonFactory()).defaultExceptionSupplier(this.defaultServiceExceptionSupplier).build());
    }

    private <T> MetricCollectingHttpResponseHandler<T> timeUnmarshalling(HttpResponseHandler<T> delegate) {
        return MetricCollectingHttpResponseHandler.create(CoreMetric.UNMARSHALLING_DURATION, delegate);
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || this.protocolMetadata.protocol() == AwsJsonProtocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    @SdkTestInternalApi
    private StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @SdkTestInternalApi
    public final String getContentType() {
        return this.protocolMetadata.contentType() != null ? this.protocolMetadata.contentType() : this.getContentTypeResolver().resolveContentType(this.protocolMetadata);
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        return AWS_JSON;
    }

    protected StructuredJsonFactory getSdkFactory() {
        return AwsStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    protected Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP);
        return Collections.unmodifiableMap(formats);
    }

    public final ProtocolMarshaller<SdkHttpFullRequest> createProtocolMarshaller(OperationInfo operationInfo) {
        return JsonProtocolMarshallerBuilder.create().endpoint(this.clientConfiguration.option(SdkClientOption.ENDPOINT)).jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).sendExplicitNullForPayload(false).protocolMetadata(this.protocolMetadata).build();
    }

    public static abstract class Builder<SubclassT extends Builder> {
        private final AwsJsonProtocolMetadata.Builder protocolMetadata = AwsJsonProtocolMetadata.builder();
        private final List<ExceptionMetadata> modeledExceptions = new ArrayList<ExceptionMetadata>();
        private Supplier<SdkPojo> defaultServiceExceptionSupplier;
        private String customErrorCodeFieldName;
        private SdkClientConfiguration clientConfiguration;

        protected Builder() {
        }

        public final SubclassT registerModeledException(ExceptionMetadata errorMetadata) {
            this.modeledExceptions.add(errorMetadata);
            return this.getSubclass();
        }

        public final SubclassT defaultServiceExceptionSupplier(Supplier<SdkPojo> exceptionBuilderSupplier) {
            this.defaultServiceExceptionSupplier = exceptionBuilderSupplier;
            return this.getSubclass();
        }

        public final SubclassT protocol(AwsJsonProtocol protocol) {
            this.protocolMetadata.protocol(protocol);
            return this.getSubclass();
        }

        public final SubclassT protocolVersion(String protocolVersion) {
            this.protocolMetadata.protocolVersion(protocolVersion);
            return this.getSubclass();
        }

        public final SubclassT contentType(String contentType) {
            this.protocolMetadata.contentType(contentType);
            return this.getSubclass();
        }

        public final SubclassT customErrorCodeFieldName(String customErrorCodeFieldName) {
            this.customErrorCodeFieldName = customErrorCodeFieldName;
            return this.getSubclass();
        }

        public final SubclassT clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this.getSubclass();
        }

        private SubclassT getSubclass() {
            return (SubclassT)this;
        }
    }
}

