/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.protocols.json.internal.marshall;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.protocols.core.OperationInfo;
import codegurushadow.software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import codegurushadow.software.amazon.awssdk.protocols.json.AwsJsonProtocolMetadata;
import codegurushadow.software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.marshall.JsonProtocolMarshaller;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.marshall.NullAsEmptyBodyProtocolRequestMarshaller;
import java.net.URI;

@SdkInternalApi
public final class JsonProtocolMarshallerBuilder {
    private URI endpoint;
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private boolean sendExplicitNullForPayload;
    private AwsJsonProtocolMetadata protocolMetadata;

    private JsonProtocolMarshallerBuilder() {
    }

    public static JsonProtocolMarshallerBuilder create() {
        return new JsonProtocolMarshallerBuilder();
    }

    public JsonProtocolMarshallerBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public JsonProtocolMarshallerBuilder jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        this.sendExplicitNullForPayload = sendExplicitNullForPayload;
        return this;
    }

    public JsonProtocolMarshallerBuilder protocolMetadata(AwsJsonProtocolMetadata protocolMetadata) {
        this.protocolMetadata = protocolMetadata;
        return this;
    }

    public ProtocolMarshaller<SdkHttpFullRequest> build() {
        JsonProtocolMarshaller protocolMarshaller = new JsonProtocolMarshaller(this.endpoint, this.jsonGenerator, this.contentType, this.operationInfo, this.protocolMetadata);
        return this.sendExplicitNullForPayload ? protocolMarshaller : new NullAsEmptyBodyProtocolRequestMarshaller(protocolMarshaller);
    }
}

