/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.SdkPojo;
import codegurushadow.software.amazon.awssdk.core.SdkStandardLogger;
import codegurushadow.software.amazon.awssdk.core.http.HttpResponseHandler;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullResponse;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonProtocolUnmarshaller;
import codegurushadow.software.amazon.awssdk.utils.FunctionalUtils;
import codegurushadow.software.amazon.awssdk.utils.IoUtils;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.util.function.Function;

@SdkInternalApi
public final class JsonResponseHandler<T extends SdkPojo>
implements HttpResponseHandler<T> {
    private final Function<SdkHttpFullResponse, SdkPojo> pojoSupplier;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadJson;
    private JsonProtocolUnmarshaller unmarshaller;

    public JsonResponseHandler(JsonProtocolUnmarshaller unmarshaller, Function<SdkHttpFullResponse, SdkPojo> pojoSupplier, boolean needsConnectionLeftOpen, boolean isPayloadJson) {
        this.unmarshaller = Validate.paramNotNull(unmarshaller, "unmarshaller");
        this.pojoSupplier = pojoSupplier;
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
        this.isPayloadJson = isPayloadJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
        SdkStandardLogger.REQUEST_LOGGER.trace(() -> "Parsing service response JSON.");
        try {
            Object result = this.unmarshaller.unmarshall(this.pojoSupplier.apply(response), response);
            if (this.shouldParsePayloadAsJson() && response.content().isPresent()) {
                IoUtils.drainInputStream(response.content().get());
            }
            SdkStandardLogger.REQUEST_LOGGER.trace(() -> "Done parsing service response.");
            Object TypeT = result;
            return (T)TypeT;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                response.content().ifPresent(i -> FunctionalUtils.invokeSafely(i::close));
            }
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsJson() {
        return !this.needsConnectionLeftOpen && this.isPayloadJson;
    }
}

