/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullResponse;
import codegurushadow.software.amazon.awssdk.protocols.json.internal.unmarshall.ErrorMessageParser;
import codegurushadow.software.amazon.awssdk.protocols.jsoncore.JsonNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@SdkInternalApi
public class SdkJsonErrorMessageParser
implements ErrorMessageParser {
    private static final List<String> DEFAULT_ERROR_MESSAGE_LOCATIONS = Arrays.asList("message", "Message", "errorMessage");
    public static final SdkJsonErrorMessageParser DEFAULT_ERROR_MESSAGE_PARSER = new SdkJsonErrorMessageParser(DEFAULT_ERROR_MESSAGE_LOCATIONS);
    private final List<String> errorMessageJsonLocations;

    private SdkJsonErrorMessageParser(List<String> errorMessageJsonLocations) {
        this.errorMessageJsonLocations = new LinkedList<String>(errorMessageJsonLocations);
    }

    @Override
    public String parseErrorMessage(SdkHttpFullResponse httpResponse, JsonNode jsonNode) {
        for (String field : this.errorMessageJsonLocations) {
            String value = jsonNode.field(field).map(JsonNode::text).orElse(null);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

