/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.regions.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.regions.GeneratedPartitionMetadataProvider;
import codegurushadow.software.amazon.awssdk.regions.GeneratedRegionMetadataProvider;
import codegurushadow.software.amazon.awssdk.regions.GeneratedServiceMetadataProvider;
import codegurushadow.software.amazon.awssdk.regions.PartitionMetadata;
import codegurushadow.software.amazon.awssdk.regions.PartitionMetadataProvider;
import codegurushadow.software.amazon.awssdk.regions.Region;
import codegurushadow.software.amazon.awssdk.regions.RegionMetadata;
import codegurushadow.software.amazon.awssdk.regions.RegionMetadataProvider;
import codegurushadow.software.amazon.awssdk.regions.ServiceMetadata;
import codegurushadow.software.amazon.awssdk.regions.ServiceMetadataProvider;

@SdkInternalApi
public final class MetadataLoader {
    private static final RegionMetadataProvider REGION_METADATA_PROVIDER = new GeneratedRegionMetadataProvider();
    private static final ServiceMetadataProvider SERVICE_METADATA_PROVIDER = new GeneratedServiceMetadataProvider();
    private static final PartitionMetadataProvider PARTITION_METADATA_PROVIDER = new GeneratedPartitionMetadataProvider();

    private MetadataLoader() {
    }

    public static PartitionMetadata partitionMetadata(Region region) {
        return PARTITION_METADATA_PROVIDER.partitionMetadata(region);
    }

    public static PartitionMetadata partitionMetadata(String partition) {
        return PARTITION_METADATA_PROVIDER.partitionMetadata(partition);
    }

    public static RegionMetadata regionMetadata(Region region) {
        return REGION_METADATA_PROVIDER.regionMetadata(region);
    }

    public static ServiceMetadata serviceMetadata(String service) {
        return SERVICE_METADATA_PROVIDER.serviceMetadata(service);
    }
}

