/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.regions.servicemetadata;

import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.regions.EndpointTag;
import codegurushadow.software.amazon.awssdk.regions.PartitionEndpointKey;
import codegurushadow.software.amazon.awssdk.regions.Region;
import codegurushadow.software.amazon.awssdk.regions.ServiceEndpointKey;
import codegurushadow.software.amazon.awssdk.regions.ServiceMetadata;
import codegurushadow.software.amazon.awssdk.regions.ServicePartitionMetadata;
import codegurushadow.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import codegurushadow.software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import codegurushadow.software.amazon.awssdk.utils.ImmutableMap;
import codegurushadow.software.amazon.awssdk.utils.Pair;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@SdkPublicApi
public final class MediaPipelinesChimeServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "media-pipelines-chime";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-southeast-1"), Region.of("eu-central-1"), Region.of("us-east-1"), Region.of("us-east-1-fips"), Region.of("us-west-2"), Region.of("us-west-2-fips")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("us-east-1-fips")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-2-fips")).build(), "us-west-2").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "media-pipelines-chime-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1-fips")).build(), "media-pipelines-chime-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "media-pipelines-chime-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2-fips")).build(), "media-pipelines-chime-fips.us-west-2.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

