/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.auth.signer.Aws4Signer;
import codegurushadow.software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientOption;
import codegurushadow.software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import codegurushadow.software.amazon.awssdk.core.retry.RetryMode;
import codegurushadow.software.amazon.awssdk.core.signer.Signer;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerBaseClientBuilder;
import codegurushadow.software.amazon.awssdk.utils.CollectionUtils;
import java.util.List;

@SdkInternalApi
abstract class DefaultCodeGuruProfilerBaseClientBuilder<B extends CodeGuruProfilerBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultCodeGuruProfilerBaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "codeguru-profiler";
    }

    @Override
    protected final String serviceName() {
        return "CodeGuruProfiler";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkAdvancedClientOption.SIGNER, this.defaultSigner()).option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    @Override
    protected final SdkClientConfiguration mergeInternalDefaults(SdkClientConfiguration config) {
        return config.merge(c -> {
            c.option(SdkClientOption.INTERNAL_USER_AGENT, "md/internal");
            c.option(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD);
        });
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory.getInterceptors("codegurushadow/software/amazon/awssdk/services/codeguruprofiler/execution.interceptors");
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return config.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    @Override
    protected final String signingName() {
        return "codeguru-profiler";
    }
}

