/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.SdkField;
import codegurushadow.software.amazon.awssdk.core.SdkPojo;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallLocation;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallingType;
import codegurushadow.software.amazon.awssdk.core.traits.ListTrait;
import codegurushadow.software.amazon.awssdk.core.traits.LocationTrait;
import codegurushadow.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import codegurushadow.software.amazon.awssdk.core.util.SdkAutoConstructList;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.Channel;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ChannelsCopier;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import codegurushadow.software.amazon.awssdk.utils.builder.CopyableBuilder;
import codegurushadow.software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AddNotificationChannelsRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, AddNotificationChannelsRequest> {
    private static final SdkField<List<Channel>> CHANNELS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("channels").getter(AddNotificationChannelsRequest.getter(AddNotificationChannelsRequest::channels)).setter(AddNotificationChannelsRequest.setter(Builder::channels)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(Channel::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("profilingGroupName").getter(AddNotificationChannelsRequest.getter(AddNotificationChannelsRequest::profilingGroupName)).setter(AddNotificationChannelsRequest.setter(Builder::profilingGroupName)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, PROFILING_GROUP_NAME_FIELD));
    private final List<Channel> channels;
    private final String profilingGroupName;

    private AddNotificationChannelsRequest(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.profilingGroupName = builder.profilingGroupName;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<Channel> channels() {
        return this.channels;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddNotificationChannelsRequest)) {
            return false;
        }
        AddNotificationChannelsRequest other = (AddNotificationChannelsRequest)obj;
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName());
    }

    public final String toString() {
        return ToString.builder("AddNotificationChannelsRequest").add("Channels", this.hasChannels() ? this.channels() : null).add("ProfilingGroupName", this.profilingGroupName()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddNotificationChannelsRequest, T> g) {
        return obj -> g.apply((AddNotificationChannelsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private List<Channel> channels = DefaultSdkAutoConstructList.getInstance();
        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(AddNotificationChannelsRequest model) {
            super(model);
            this.channels(model.channels);
            this.profilingGroupName(model.profilingGroupName);
        }

        public final List<Channel.Builder> getChannels() {
            List<Channel.Builder> result = ChannelsCopier.copyToBuilder(this.channels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannels(Collection<Channel.BuilderImpl> channels) {
            this.channels = ChannelsCopier.copyFromBuilder(channels);
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<Channel.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddNotificationChannelsRequest build() {
            return new AddNotificationChannelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddNotificationChannelsRequest> {
        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder channels(Consumer<Channel.Builder> ... var1);

        public Builder profilingGroupName(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

