/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.SdkField;
import codegurushadow.software.amazon.awssdk.core.SdkPojo;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallLocation;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallingType;
import codegurushadow.software.amazon.awssdk.core.traits.DefaultValueTrait;
import codegurushadow.software.amazon.awssdk.core.traits.LocationTrait;
import codegurushadow.software.amazon.awssdk.core.traits.MapTrait;
import codegurushadow.software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import codegurushadow.software.amazon.awssdk.core.util.SdkAutoConstructMap;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.TagsMapCopier;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import codegurushadow.software.amazon.awssdk.utils.builder.CopyableBuilder;
import codegurushadow.software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CreateProfilingGroupRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, CreateProfilingGroupRequest> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("agentOrchestrationConfig").getter(CreateProfilingGroupRequest.getter(CreateProfilingGroupRequest::agentOrchestrationConfig)).setter(CreateProfilingGroupRequest.setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build()).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientToken").getter(CreateProfilingGroupRequest.getter(CreateProfilingGroupRequest::clientToken)).setter(CreateProfilingGroupRequest.setter(Builder::clientToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder(MarshallingType.STRING).memberName("computePlatform").getter(CreateProfilingGroupRequest.getter(CreateProfilingGroupRequest::computePlatformAsString)).setter(CreateProfilingGroupRequest.setter(Builder::computePlatform)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("profilingGroupName").getter(CreateProfilingGroupRequest.getter(CreateProfilingGroupRequest::profilingGroupName)).setter(CreateProfilingGroupRequest.setter(Builder::profilingGroupName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build()).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("tags").getter(CreateProfilingGroupRequest.getter(CreateProfilingGroupRequest::tags)).setter(CreateProfilingGroupRequest.setter(Builder::tags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ORCHESTRATION_CONFIG_FIELD, CLIENT_TOKEN_FIELD, COMPUTE_PLATFORM_FIELD, PROFILING_GROUP_NAME_FIELD, TAGS_FIELD));
    private final AgentOrchestrationConfig agentOrchestrationConfig;
    private final String clientToken;
    private final String computePlatform;
    private final String profilingGroupName;
    private final Map<String, String> tags;

    private CreateProfilingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.clientToken = builder.clientToken;
        this.computePlatform = builder.computePlatform;
        this.profilingGroupName = builder.profilingGroupName;
        this.tags = builder.tags;
    }

    public final AgentOrchestrationConfig agentOrchestrationConfig() {
        return this.agentOrchestrationConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public final String computePlatformAsString() {
        return this.computePlatform;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfilingGroupRequest)) {
            return false;
        }
        CreateProfilingGroupRequest other = (CreateProfilingGroupRequest)obj;
        return Objects.equals(this.agentOrchestrationConfig(), other.agentOrchestrationConfig()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder("CreateProfilingGroupRequest").add("AgentOrchestrationConfig", this.agentOrchestrationConfig()).add("ClientToken", this.clientToken()).add("ComputePlatform", this.computePlatformAsString()).add("ProfilingGroupName", this.profilingGroupName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentOrchestrationConfig": {
                return Optional.ofNullable(clazz.cast(this.agentOrchestrationConfig()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfilingGroupRequest, T> g) {
        return obj -> g.apply((CreateProfilingGroupRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;
        private String clientToken;
        private String computePlatform;
        private String profilingGroupName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfilingGroupRequest model) {
            super(model);
            this.agentOrchestrationConfig(model.agentOrchestrationConfig);
            this.clientToken(model.clientToken);
            this.computePlatform(model.computePlatform);
            this.profilingGroupName(model.profilingGroupName);
            this.tags(model.tags);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return this.agentOrchestrationConfig != null ? this.agentOrchestrationConfig.toBuilder() : null;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfilingGroupRequest build() {
            return new CreateProfilingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfilingGroupRequest> {
        public Builder agentOrchestrationConfig(AgentOrchestrationConfig var1);

        default public Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return this.agentOrchestrationConfig((AgentOrchestrationConfig)AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        public Builder clientToken(String var1);

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder profilingGroupName(String var1);

        public Builder tags(Map<String, String> var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

