/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.utils.internal.EnumUtils;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum EventPublisher {
    ANOMALY_DETECTION("AnomalyDetection"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventPublisher> VALUE_MAP;
    private final String value;

    private EventPublisher(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventPublisher fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventPublisher> knownValues() {
        EnumSet<EventPublisher> knownValues = EnumSet.allOf(EventPublisher.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventPublisher.class, EventPublisher::toString);
    }
}

