/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.core.SdkField;
import codegurushadow.software.amazon.awssdk.core.SdkPojo;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallLocation;
import codegurushadow.software.amazon.awssdk.core.protocol.MarshallingType;
import codegurushadow.software.amazon.awssdk.core.traits.ListTrait;
import codegurushadow.software.amazon.awssdk.core.traits.LocationTrait;
import codegurushadow.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import codegurushadow.software.amazon.awssdk.core.util.SdkAutoConstructList;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescriptionsCopier;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupNamesCopier;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import codegurushadow.software.amazon.awssdk.utils.builder.CopyableBuilder;
import codegurushadow.software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ListProfilingGroupsResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, ListProfilingGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::nextToken)).setter(ListProfilingGroupsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();
    private static final SdkField<List<String>> PROFILING_GROUP_NAMES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("profilingGroupNames").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::profilingGroupNames)).setter(ListProfilingGroupsResponse.setter(Builder::profilingGroupNames)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<List<ProfilingGroupDescription>> PROFILING_GROUPS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("profilingGroups").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::profilingGroups)).setter(ListProfilingGroupsResponse.setter(Builder::profilingGroups)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ProfilingGroupDescription::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROFILING_GROUP_NAMES_FIELD, PROFILING_GROUPS_FIELD));
    private final String nextToken;
    private final List<String> profilingGroupNames;
    private final List<ProfilingGroupDescription> profilingGroups;

    private ListProfilingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profilingGroupNames = builder.profilingGroupNames;
        this.profilingGroups = builder.profilingGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProfilingGroupNames() {
        return this.profilingGroupNames != null && !(this.profilingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> profilingGroupNames() {
        return this.profilingGroupNames;
    }

    public final boolean hasProfilingGroups() {
        return this.profilingGroups != null && !(this.profilingGroups instanceof SdkAutoConstructList);
    }

    public final List<ProfilingGroupDescription> profilingGroups() {
        return this.profilingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilingGroupNames() ? this.profilingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilingGroups() ? this.profilingGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilingGroupsResponse)) {
            return false;
        }
        ListProfilingGroupsResponse other = (ListProfilingGroupsResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProfilingGroupNames() == other.hasProfilingGroupNames() && Objects.equals(this.profilingGroupNames(), other.profilingGroupNames()) && this.hasProfilingGroups() == other.hasProfilingGroups() && Objects.equals(this.profilingGroups(), other.profilingGroups());
    }

    public final String toString() {
        return ToString.builder("ListProfilingGroupsResponse").add("NextToken", this.nextToken()).add("ProfilingGroupNames", this.hasProfilingGroupNames() ? this.profilingGroupNames() : null).add("ProfilingGroups", this.hasProfilingGroups() ? this.profilingGroups() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "profilingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupNames()));
            }
            case "profilingGroups": {
                return Optional.ofNullable(clazz.cast(this.profilingGroups()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilingGroupsResponse, T> g) {
        return obj -> g.apply((ListProfilingGroupsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> profilingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<ProfilingGroupDescription> profilingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilingGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.profilingGroupNames(model.profilingGroupNames);
            this.profilingGroups(model.profilingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getProfilingGroupNames() {
            if (this.profilingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profilingGroupNames;
        }

        public final void setProfilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
        }

        @Override
        public final Builder profilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroupNames(String ... profilingGroupNames) {
            this.profilingGroupNames(Arrays.asList(profilingGroupNames));
            return this;
        }

        public final List<ProfilingGroupDescription.Builder> getProfilingGroups() {
            List<ProfilingGroupDescription.Builder> result = ProfilingGroupDescriptionsCopier.copyToBuilder(this.profilingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfilingGroups(Collection<ProfilingGroupDescription.BuilderImpl> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copyFromBuilder(profilingGroups);
        }

        @Override
        public final Builder profilingGroups(Collection<ProfilingGroupDescription> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copy(profilingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(ProfilingGroupDescription ... profilingGroups) {
            this.profilingGroups(Arrays.asList(profilingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder> ... profilingGroups) {
            this.profilingGroups(Stream.of(profilingGroups).map(c -> (ProfilingGroupDescription)((ProfilingGroupDescription.Builder)ProfilingGroupDescription.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProfilingGroupsResponse build() {
            return new ListProfilingGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfilingGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder profilingGroupNames(Collection<String> var1);

        public Builder profilingGroupNames(String ... var1);

        public Builder profilingGroups(Collection<ProfilingGroupDescription> var1);

        public Builder profilingGroups(ProfilingGroupDescription ... var1);

        public Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder> ... var1);
    }
}

