/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.utils.internal.EnumUtils;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum MetadataField {
    COMPUTE_PLATFORM("ComputePlatform"),
    AGENT_ID("AgentId"),
    AWS_REQUEST_ID("AwsRequestId"),
    EXECUTION_ENVIRONMENT("ExecutionEnvironment"),
    LAMBDA_FUNCTION_ARN("LambdaFunctionArn"),
    LAMBDA_MEMORY_LIMIT_IN_MB("LambdaMemoryLimitInMB"),
    LAMBDA_REMAINING_TIME_IN_MILLISECONDS("LambdaRemainingTimeInMilliseconds"),
    LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS("LambdaTimeGapBetweenInvokesInMilliseconds"),
    LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS("LambdaPreviousExecutionTimeInMilliseconds"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetadataField> VALUE_MAP;
    private final String value;

    private MetadataField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetadataField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetadataField> knownValues() {
        EnumSet<MetadataField> knownValues = EnumSet.allOf(MetadataField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetadataField.class, MetadataField::toString);
    }
}

