/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model;

import codegurushadow.software.amazon.awssdk.utils.internal.EnumUtils;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum MetricType {
    AGGREGATED_RELATIVE_TOTAL_TIME("AggregatedRelativeTotalTime"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricType> VALUE_MAP;
    private final String value;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricType> knownValues() {
        EnumSet<MetricType> knownValues = EnumSet.allOf(MetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricType.class, MetricType::toString);
    }
}

