/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SdkIterable;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse;
import java.util.Iterator;

public class ListFindingsReportsIterable
implements SdkIterable<ListFindingsReportsResponse> {
    private final CodeGuruProfilerClient client;
    private final ListFindingsReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsReportsIterable(CodeGuruProfilerClient client, ListFindingsReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingsReportsResponseFetcher();
    }

    @Override
    public Iterator<ListFindingsReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFindingsReportsResponseFetcher
    implements SyncPageFetcher<ListFindingsReportsResponse> {
        private ListFindingsReportsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListFindingsReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListFindingsReportsResponse nextPage(ListFindingsReportsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsReportsIterable.this.client.listFindingsReports(ListFindingsReportsIterable.this.firstRequest);
            }
            return ListFindingsReportsIterable.this.client.listFindingsReports((ListFindingsReportsRequest)ListFindingsReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

