/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.org.reactivestreams.Subscriber;
import codegurushadow.software.amazon.awssdk.core.async.SdkPublisher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse;
import java.util.concurrent.CompletableFuture;

public class ListFindingsReportsPublisher
implements SdkPublisher<ListFindingsReportsResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListFindingsReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsReportsPublisher(CodeGuruProfilerAsyncClient client, ListFindingsReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsReportsPublisher(CodeGuruProfilerAsyncClient client, ListFindingsReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsReportsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListFindingsReportsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFindingsReportsResponseFetcher
    implements AsyncPageFetcher<ListFindingsReportsResponse> {
        private ListFindingsReportsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListFindingsReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListFindingsReportsResponse> nextPage(ListFindingsReportsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsReportsPublisher.this.client.listFindingsReports(ListFindingsReportsPublisher.this.firstRequest);
            }
            return ListFindingsReportsPublisher.this.client.listFindingsReports((ListFindingsReportsRequest)ListFindingsReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

