/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SdkIterable;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;

public class ListProfileTimesIterable
implements SdkIterable<ListProfileTimesResponse> {
    private final CodeGuruProfilerClient client;
    private final ListProfileTimesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileTimesIterable(CodeGuruProfilerClient client, ListProfileTimesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProfileTimesResponseFetcher();
    }

    @Override
    public Iterator<ListProfileTimesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProfileTime> profileTimes() {
        Function<ListProfileTimesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileTimes() != null) {
                return response.profileTimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListProfileTimesResponseFetcher
    implements SyncPageFetcher<ListProfileTimesResponse> {
        private ListProfileTimesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListProfileTimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListProfileTimesResponse nextPage(ListProfileTimesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileTimesIterable.this.client.listProfileTimes(ListProfileTimesIterable.this.firstRequest);
            }
            return ListProfileTimesIterable.this.client.listProfileTimes((ListProfileTimesRequest)ListProfileTimesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

