/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.org.reactivestreams.Subscriber;
import codegurushadow.software.amazon.awssdk.core.async.SdkPublisher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ListProfileTimesPublisher
implements SdkPublisher<ListProfileTimesResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListProfileTimesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileTimesPublisher(CodeGuruProfilerAsyncClient client, ListProfileTimesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileTimesPublisher(CodeGuruProfilerAsyncClient client, ListProfileTimesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileTimesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListProfileTimesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProfileTime> profileTimes() {
        Function<ListProfileTimesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileTimes() != null) {
                return response.profileTimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListProfileTimesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProfileTimesResponseFetcher
    implements AsyncPageFetcher<ListProfileTimesResponse> {
        private ListProfileTimesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListProfileTimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListProfileTimesResponse> nextPage(ListProfileTimesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileTimesPublisher.this.client.listProfileTimes(ListProfileTimesPublisher.this.firstRequest);
            }
            return ListProfileTimesPublisher.this.client.listProfileTimes((ListProfileTimesRequest)ListProfileTimesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

