/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SdkIterable;
import codegurushadow.software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;
import java.util.Iterator;

public class ListProfilingGroupsIterable
implements SdkIterable<ListProfilingGroupsResponse> {
    private final CodeGuruProfilerClient client;
    private final ListProfilingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfilingGroupsIterable(CodeGuruProfilerClient client, ListProfilingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProfilingGroupsResponseFetcher();
    }

    @Override
    public Iterator<ListProfilingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfilingGroupsResponseFetcher
    implements SyncPageFetcher<ListProfilingGroupsResponse> {
        private ListProfilingGroupsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListProfilingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListProfilingGroupsResponse nextPage(ListProfilingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProfilingGroupsIterable.this.client.listProfilingGroups(ListProfilingGroupsIterable.this.firstRequest);
            }
            return ListProfilingGroupsIterable.this.client.listProfilingGroups((ListProfilingGroupsRequest)ListProfilingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

