/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.services.codeguruprofiler.paginators;

import codegurushadow.org.reactivestreams.Subscriber;
import codegurushadow.software.amazon.awssdk.core.async.SdkPublisher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import codegurushadow.software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import codegurushadow.software.amazon.awssdk.core.util.PaginatorUtils;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;
import java.util.concurrent.CompletableFuture;

public class ListProfilingGroupsPublisher
implements SdkPublisher<ListProfilingGroupsResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListProfilingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfilingGroupsPublisher(CodeGuruProfilerAsyncClient client, ListProfilingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfilingGroupsPublisher(CodeGuruProfilerAsyncClient client, ListProfilingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfilingGroupsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListProfilingGroupsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProfilingGroupsResponseFetcher
    implements AsyncPageFetcher<ListProfilingGroupsResponse> {
        private ListProfilingGroupsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListProfilingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListProfilingGroupsResponse> nextPage(ListProfilingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProfilingGroupsPublisher.this.client.listProfilingGroups(ListProfilingGroupsPublisher.this.firstRequest);
            }
            return ListProfilingGroupsPublisher.this.client.listProfilingGroups((ListProfilingGroupsRequest)ListProfilingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

