/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.utils;

import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import java.util.stream.Stream;

@SdkProtectedApi
public final class ComparableUtils {
    private ComparableUtils() {
    }

    public static <T> int safeCompare(Comparable<T> d1, T d2) {
        if (d1 != null && d2 != null) {
            return d1.compareTo(d2);
        }
        if (d1 == null && d2 != null) {
            return -1;
        }
        if (d1 != null) {
            return 1;
        }
        return 0;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T minimum(T ... values2) {
        return (T)(values2 == null ? null : (Comparable)Stream.of(values2).min(Comparable::compareTo).orElse(null));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T maximum(T ... values2) {
        return (T)(values2 == null ? null : (Comparable)Stream.of(values2).max(Comparable::compareTo).orElse(null));
    }
}

