/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.utils;

import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.util.concurrent.ThreadFactory;

@SdkProtectedApi
public class DaemonThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;

    public DaemonThreadFactory(ThreadFactory delegate) {
        this.delegate = Validate.notNull(delegate, "delegate must not be null", new Object[0]);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread2 = this.delegate.newThread(runnable);
        thread2.setDaemon(true);
        return thread2;
    }
}

