/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.utils;

import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@SdkProtectedApi
public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;
    private final String namePrefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);

    public NamedThreadFactory(ThreadFactory delegate, String namePrefix) {
        this.delegate = Validate.notNull(delegate, "delegate must not be null", new Object[0]);
        this.namePrefix = Validate.notBlank(namePrefix, "namePrefix must not be blank", new Object[0]);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread2 = this.delegate.newThread(runnable);
        thread2.setName(this.namePrefix + "-" + this.threadCount.getAndIncrement());
        return thread2;
    }
}

