/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.utils.async;

import codegurushadow.org.reactivestreams.Subscriber;
import codegurushadow.org.reactivestreams.Subscription;
import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.utils.async.DelegatingSubscriber;
import java.util.function.Predicate;

@SdkProtectedApi
public class FilteringSubscriber<T>
extends DelegatingSubscriber<T, T> {
    private final Predicate<T> predicate;
    private Subscription subscription;

    public FilteringSubscriber(Subscriber<? super T> sourceSubscriber, Predicate<T> predicate) {
        super(sourceSubscriber);
        this.predicate = predicate;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        super.onSubscribe(subscription);
    }

    @Override
    public void onNext(T t) {
        try {
            if (this.predicate.test(t)) {
                this.subscriber.onNext(t);
            } else {
                this.subscription.request(1L);
            }
        }
        catch (RuntimeException e) {
            this.subscription.cancel();
            this.onError(e);
        }
    }
}

