/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.exception.SdkException;
import codegurushadow.software.amazon.awssdk.core.retry.RetryPolicy;
import codegurushadow.software.amazon.awssdk.core.retry.RetryPolicyContext;
import codegurushadow.software.amazon.awssdk.core.retry.RetryUtils;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.RetryCondition;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import java.util.logging.Logger;

final class CodeGuruProfilerSDKClientOverrideConfiguration {
    private static final Logger LOG = Logger.getLogger(CodeGuruProfilerSDKClientOverrideConfiguration.class.getName());
    private static final RetryCondition RETRY_CONDITION = new RetryCondition(){

        @Override
        public boolean shouldRetry(RetryPolicyContext retryPolicyContext) {
            SdkRequest request = retryPolicyContext.originalRequest();
            SdkException exception = retryPolicyContext.exception();
            if (request instanceof ConfigureAgentRequest && RetryUtils.isThrottlingException(exception)) {
                LOG.finest(String.format("No retries because the operation is %s and the exception is %s", request.getClass().getSimpleName(), exception));
                return false;
            }
            LOG.finest(String.format("Setting the default retry for %s and exception %s", request.getClass().getSimpleName(), exception));
            return RetryCondition.defaultRetryCondition().shouldRetry(retryPolicyContext);
        }
    };
    private static final RetryPolicy RETRY_POLICY = RetryPolicy.defaultRetryPolicy().toBuilder().retryCondition(RETRY_CONDITION).build();
    static final ClientOverrideConfiguration DEFAULT = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RETRY_POLICY).build();

    private CodeGuruProfilerSDKClientOverrideConfiguration() {
    }
}

