/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfileReporter;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.Profile;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.ProfileIonSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSystemProfileReporter
implements ProfileReporter<Profile> {
    private static final Logger LOG = Logger.getLogger(FileSystemProfileReporter.class.getName());
    private static final String DEFAULT_SUFFIX_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss-SSS";
    private final ProfileIonSerializer serializer;
    private final String filenamePrefix;
    private final DateTimeFormatter formatter;

    public FileSystemProfileReporter(ProfileIonSerializer serializer, String fileName) {
        this(serializer, fileName, DateTimeFormatter.ofPattern(DEFAULT_SUFFIX_DATE_FORMAT).withZone(ZoneId.systemDefault()));
    }

    public FileSystemProfileReporter(ProfileIonSerializer serializer, String fileName, DateTimeFormatter dateTimeFormatter) {
        this.serializer = serializer;
        this.filenamePrefix = fileName;
        this.formatter = dateTimeFormatter;
    }

    private String makeFileName() {
        return this.filenamePrefix + "_" + this.formatter.format(Instant.now());
    }

    private File makeFile() throws IOException {
        File file = new File(this.makeFileName());
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to Create directories: " + parent.getPath());
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean report(Profile profile) {
        try (FileOutputStream output = new FileOutputStream(this.makeFile());){
            this.serializer.serialize(profile, output);
            output.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Failed to render call graph to disk", ioe);
            return false;
        }
    }
}

