/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

class KillSwitch {
    private static final Logger LOG = Logger.getLogger(KillSwitch.class.getName());
    private static final String KILLSWITCH_FILEPATH = "/var/tmp/killProfiler";
    private static final long KILLSWITCH_CHECK_INTERVAL_NANO = TimeUnit.SECONDS.toNanos(60L);
    private long lastKillSwitchCheck = System.nanoTime();
    private boolean lastValue;

    KillSwitch() {
    }

    boolean isKillSwitchOn(boolean forceCheck) {
        long timeSinceLastCheck = System.nanoTime() - this.lastKillSwitchCheck;
        if (!forceCheck && timeSinceLastCheck < KILLSWITCH_CHECK_INTERVAL_NANO) {
            return this.lastValue;
        }
        this.lastKillSwitchCheck = System.nanoTime();
        if (new File(KILLSWITCH_FILEPATH).exists()) {
            LOG.info("Found kill-switch file at /var/tmp/killProfiler, attempting to terminate Profiler.");
            this.lastValue = true;
        } else {
            LOG.fine("Did not find kill-switch file at /var/tmp/killProfiler, continuing Profiler as normal.");
            this.lastValue = false;
        }
        return this.lastValue;
    }
}

