/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.com.amazonaws.services.lambda.runtime.Context;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.LambdaProfilerUtils;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Logger;

public final class LambdaProfiler {
    private static final Logger LOG = Logger.getLogger(LambdaProfiler.class.getName());
    private static ProfilerWithPause profilerWithPause;
    private static boolean createProfilerAttempted;

    private LambdaProfiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> O profile(I input, Context context, BiFunction<I, Context, O> handlerFunction) {
        LambdaProfiler.resumeProfiler(context);
        try {
            O o = handlerFunction.apply(input, context);
            return o;
        }
        finally {
            LambdaProfiler.pauseProfiler(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O, E extends Throwable> O profileWithException(I input, Context context, ThrowingBiFunction<I, O, E> handlerFunction) throws E {
        LambdaProfiler.resumeProfiler(context);
        try {
            O o = handlerFunction.apply(input, context);
            return o;
        }
        finally {
            LambdaProfiler.pauseProfiler(context);
        }
    }

    public static <I> void profile(I input, Context context, BiConsumer<I, Context> handlerFunction) {
        LambdaProfiler.resumeProfiler(context);
        try {
            handlerFunction.accept(input, context);
        }
        finally {
            LambdaProfiler.pauseProfiler(context);
        }
    }

    public static <I, E extends Throwable> void profileWithException(I input, Context context, ThrowingBiConsumer<I, E> handlerFunction) throws E {
        LambdaProfiler.resumeProfiler(context);
        try {
            handlerFunction.apply(input, context);
        }
        finally {
            LambdaProfiler.pauseProfiler(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void profile(InputStream is, OutputStream os, Context context, StreamHandlerFunction handlerFunction) throws IOException {
        LambdaProfiler.resumeProfiler(context);
        try {
            handlerFunction.apply(is, os, context);
        }
        finally {
            LambdaProfiler.pauseProfiler(context);
        }
    }

    private static void resumeProfiler(Context context) {
        try {
            if (LambdaProfiler.getProfiler(context) != null) {
                LambdaProfiler.getProfiler(context).resume(context);
            }
        }
        catch (Exception e) {
            LOG.info("Exception while starting/resuming profiler, disabling profiler. " + e);
            profilerWithPause = null;
        }
    }

    private static void pauseProfiler(Context context) {
        try {
            if (LambdaProfiler.getProfiler(context) != null) {
                LambdaProfiler.getProfiler(context).pause();
            }
        }
        catch (Exception e) {
            LOG.info("Exception while pausing profiler, disabling profiler. " + e);
            profilerWithPause = null;
        }
    }

    private static ProfilerWithPause getProfiler(Context context) {
        if (!createProfilerAttempted) {
            createProfilerAttempted = true;
            if (LambdaProfilerUtils.isProfilerEnabled()) {
                profilerWithPause = LambdaProfilerUtils.attemptToCreateProfiler(context);
            }
        }
        return profilerWithPause;
    }

    static void reset() {
        if (profilerWithPause != null) {
            profilerWithPause.stop();
            profilerWithPause = null;
        }
        createProfilerAttempted = false;
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<I, E extends Throwable> {
        public void apply(I var1, Context var2) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<I, E extends Throwable> {
        public void apply(I var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<I, O, E extends Throwable> {
        public O apply(I var1, Context var2) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<I, O, E extends Throwable> {
        public O apply(I var1) throws E;
    }

    @FunctionalInterface
    public static interface StreamHandlerFunction {
        public void apply(InputStream var1, OutputStream var2, Context var3) throws IOException;
    }
}

