/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.com.amazonaws.services.lambda.runtime.Context;
import codegurushadow.software.amazon.awssdk.regions.Region;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilingArguments;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.utils.ext.StringUtils;
import java.util.logging.Logger;

public final class LambdaProfilerUtils {
    private static final Logger LOG = Logger.getLogger(LambdaProfilerUtils.class.getName());
    public static final String AWS_LAMBDA_FUNCTION_NAME_ENV_VAR_KEY = "AWS_LAMBDA_FUNCTION_NAME";
    private static final String LAMBDA_EXECUTION_REGION = "AWS_REGION";
    private static final int REGION_INDEX_IN_PROFILING_GROUP_ARN = 3;
    private static final String PROFILING_GROUP_NAME_SEPARATOR = "/";
    private static EnvironmentReader environmentReader = new EnvironmentReader();

    private LambdaProfilerUtils() {
    }

    static ProfilerWithPause attemptToCreateProfiler(Context context) {
        String profilingGroupName = LambdaProfilerUtils.getProfilingGroupName();
        Region profilingGroupRegion = Region.of(LambdaProfilerUtils.getProfilingGroupRegion());
        LOG.info(String.format("CodeGuru profiling group: %s in AWS region: %s will be used for profiling your lambda function", profilingGroupName, profilingGroupRegion));
        return new ProfilerWithPause.Builder().profilingGroupName(profilingGroupName).awsRegionToReportTo(profilingGroupRegion).context(context).withHeapSummary(LambdaProfilerUtils.isHeapSummaryEnabled()).environmentReader(environmentReader).build();
    }

    public static boolean isProfilerEnabled() {
        String envValue = LambdaProfilerUtils.getEnv().get(ProfilingArguments.PROFILER_ENABLED.getEnvironmentVariableName());
        if (StringUtils.isNotBlank(envValue)) {
            return Boolean.parseBoolean(envValue);
        }
        return true;
    }

    static Boolean isHeapSummaryEnabled() {
        String envValue = LambdaProfilerUtils.getEnv().get(ProfilingArguments.HEAP_SUMMARY_ENABLED.getEnvironmentVariableName());
        if (StringUtils.isNotBlank(envValue)) {
            return Boolean.parseBoolean(envValue);
        }
        return false;
    }

    private static EnvironmentReader getEnv() {
        return environmentReader;
    }

    static void setEnv(EnvironmentReader newEnvironmentReader) {
        environmentReader = newEnvironmentReader;
    }

    static String getProfilingGroupRegion() {
        String profilingGroupRegion = LambdaProfilerUtils.getEnv().get(ProfilingArguments.REGION.getEnvironmentVariableName());
        String profilingGroupArn = LambdaProfilerUtils.getEnv().get(ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName());
        if (StringUtils.isNotBlank(profilingGroupArn)) {
            String[] parts = profilingGroupArn.split(":");
            if (parts.length > 3 && !parts[3].isEmpty()) {
                if (StringUtils.isNotBlank(profilingGroupRegion)) {
                    LOG.info(String.format("Both %s and %s environment variable were found. Profiling group region from the profiling group ARN will be used to profile your lambda function.", ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName(), ProfilingArguments.PROFILING_GROUP_NAME.getEnvironmentVariableName()));
                }
                profilingGroupRegion = parts[3];
            } else {
                LOG.info("Malformed or no profiling group arn specified in environment variable " + ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName());
            }
        }
        if (StringUtils.isBlank(profilingGroupRegion)) {
            profilingGroupRegion = LambdaProfilerUtils.getEnv().get(LAMBDA_EXECUTION_REGION);
            LOG.info(String.format("Profiling group region was not found and the AWS region in which Lambda function is being executed will be used. If you need to change this, please specify profiling group region either by setting the %s or %s as a part of your Lambda function's environment variables", ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName(), ProfilingArguments.REGION.getEnvironmentVariableName()));
        }
        return profilingGroupRegion;
    }

    static String getProfilingGroupName() {
        String profilingGroupName = LambdaProfilerUtils.getEnv().get(ProfilingArguments.PROFILING_GROUP_NAME.getEnvironmentVariableName());
        String profilingGroupArn = LambdaProfilerUtils.getEnv().get(ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName());
        if (StringUtils.isNotBlank(profilingGroupArn)) {
            String profilingGroupFromArn = StringUtils.substringAfterLast(profilingGroupArn, PROFILING_GROUP_NAME_SEPARATOR);
            if (StringUtils.isNotBlank(profilingGroupFromArn)) {
                if (StringUtils.isNotBlank(profilingGroupName)) {
                    LOG.info(String.format("Both %s and %s environment variable were found. Profiling group name from the profiling group ARN will be used to profile your lambda function.", ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName(), ProfilingArguments.PROFILING_GROUP_NAME.getEnvironmentVariableName()));
                }
                profilingGroupName = profilingGroupFromArn;
            } else {
                LOG.info("Malformed or no profiling group arn specified in environment variable " + ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName());
            }
        }
        if (StringUtils.isBlank(profilingGroupName)) {
            LOG.info(String.format("Profiling group name was not found. Using default profiling group name.If you want to use a particular profiling group name, please do so by specifyingprofiling group name either by setting the %s or %s as a part of yourLambda function's environment variables", ProfilingArguments.PROFILING_GROUP_ARN.getEnvironmentVariableName(), ProfilingArguments.PROFILING_GROUP_NAME.getEnvironmentVariableName()));
            String lambdaFunctionName = LambdaProfilerUtils.getEnv().get(AWS_LAMBDA_FUNCTION_NAME_ENV_VAR_KEY);
            profilingGroupName = String.format("aws-lambda-%s", lambdaFunctionName);
        }
        return profilingGroupName;
    }
}

