/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.com.amazonaws.services.lambda.runtime.Context;
import codegurushadow.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import codegurushadow.software.amazon.awssdk.regions.Region;
import codegurushadow.software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientProvider;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.IProfiler;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.PausableProfiler;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.Profiler;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilingCommandAccessor;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilingCommandWithPause;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.configuration.ProfilerParametersMerger;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataProvider;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Logger;

public class ProfilerWithPause
extends ProfilingCommandAccessor
implements IProfiler,
PausableProfiler {
    private static final Logger LOG = Logger.getLogger(ProfilerWithPause.class.getName());
    private final Profiler internalProfiler;

    ProfilerWithPause(ProfilerParameters parameters, ProfilerFinalParameters profilerFinalParameters) {
        this.internalProfiler = new Profiler(parameters, profilerFinalParameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startWithProfilingCommand((parametersMerger, parameters, profilerFinalParameters) -> this.createNewProfilingCommand((ProfilerParametersMerger)parametersMerger, (ProfilerParameters)parameters, (ProfilerFinalParameters)profilerFinalParameters));
    }

    @Override
    public void stop() {
        this.internalProfiler.stop();
    }

    @Override
    public boolean isRunning() {
        return this.internalProfiler.isRunning();
    }

    @Override
    public boolean isProfiling() {
        return this.internalProfiler.isProfiling();
    }

    @Override
    public void pause() {
        this.getProfilingCommand().ifPresent(command -> ((ProfilingCommandWithPause)command).pauseProfiling());
    }

    @Override
    public void resume(Context context) {
        Optional<ProfilingCommandWithPause> command = this.getProfilingCommand().map(c -> (ProfilingCommandWithPause)c);
        if (command.isPresent()) {
            command.get().resumeProfiling(context);
        } else {
            this.start();
        }
    }

    @Override
    Optional<ProfilingCommands> getProfilingCommand() {
        return this.internalProfiler.getProfilingCommand();
    }

    @Override
    boolean setProfilingCommand(ProfilingCommands expectedValue, ProfilingCommands UpdatedValue) {
        return this.internalProfiler.setProfilingCommand(expectedValue, UpdatedValue);
    }

    @Override
    ProfilingCommands createNewProfilingCommand(ProfilerParametersMerger parametersMerger, ProfilerParameters params, ProfilerFinalParameters finalParams) {
        return new ProfilingCommandWithPause(parametersMerger, params, finalParams);
    }

    @Override
    void startWithProfilingCommand(ProfilingCommandAccessor.TriFunction<ProfilerParametersMerger, ProfilerParameters, ProfilerFinalParameters, ProfilingCommands> profilingCommandProvider) {
        this.internalProfiler.startWithProfilingCommand(profilingCommandProvider);
    }

    @Override
    public boolean isSamplingPaused() {
        return this.getProfilingCommand().map(c -> ((ProfilingCommandWithPause)c).isSamplingPaused()).orElse(false);
    }

    public String toString() {
        return "LambdaProfiler{profilingMetadata=" + this.internalProfiler.toString() + '}';
    }

    public static class Builder {
        private final ProfilerParameters.ProfilerParametersBuilder parametersBuilder = ProfilerParameters.builder();
        private final ProfilerFinalParameters.ProfilerFinalParametersBuilder finalParametersBuilder = ProfilerFinalParameters.builder();
        private final CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder;
        private final BiFunction<ProfilerParameters, ProfilerFinalParameters, ProfilerWithPause> constructor;
        private final ErrorsMetadata errorsMetadata = new ErrorsMetadata();
        private Context context;
        private EnvironmentReader environmentReader;
        private String lambdaInvokedFunctionArn;

        Builder() {
            this(CodeGuruProfilerSDKClientProvider.builder().computePlatform(ComputePlatform.AWS_LAMBDA.toString()), ProfilerWithPause::new);
            this.codeGuruClientBuilder.errorsMetadata(this.errorsMetadata);
            this.finalParametersBuilder.codeGuruClientBuilder(this.codeGuruClientBuilder).errorsMetadata(this.errorsMetadata);
        }

        public Builder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.codeGuruClientBuilder.awsCredentialsProvider(awsCredentialsProvider);
            return this;
        }

        public Builder awsRegionToReportTo(Region awsRegion) {
            this.codeGuruClientBuilder.awsRegion(awsRegion);
            return this;
        }

        public Builder profilingGroupName(String profilingGroupName) {
            this.parametersBuilder.profilingGroupName(profilingGroupName);
            this.codeGuruClientBuilder.profilingGroupName(profilingGroupName);
            return this;
        }

        public Builder integrationModeStandalone() {
            this.parametersBuilder.integrationMode("-standalone");
            return this;
        }

        public Builder withHeapSummary(boolean shouldEnableHeapSummary) {
            this.parametersBuilder.heapSummaryEnabled(shouldEnableHeapSummary);
            return this;
        }

        public String getProfilingGroupName() {
            return this.parametersBuilder.getProfilingGroupName();
        }

        public AwsCredentialsProvider getAwsCredentialProvider() {
            return this.codeGuruClientBuilder.getAwsCredentialsProvider();
        }

        public Region getAwsRegion() {
            return this.codeGuruClientBuilder.getAwsRegion();
        }

        public Builder lambdaInvokedFunctionArn(String lambdaInvokedFunctionArn) {
            this.lambdaInvokedFunctionArn = lambdaInvokedFunctionArn;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder environmentReader(EnvironmentReader environmentReader) {
            this.environmentReader = environmentReader;
            return this;
        }

        public ProfilerWithPause build() {
            this.finalizeParameters();
            return this.constructor.apply(this.parametersBuilder.build(), this.finalParametersBuilder.build());
        }

        protected void finalizeParameters() {
            AgentMetadata agentMetadata = AgentMetadataProvider.buildLambdaAgentMetadata(this.context, this.lambdaInvokedFunctionArn, this.environmentReader, this.errorsMetadata, this.parametersBuilder.build().getIntegrationMode());
            this.parametersBuilder.addProfilerOverheadAsSamples(false);
            this.finalParametersBuilder.agentMetadata(agentMetadata);
        }

        @ConstructorProperties(value={"codeGuruClientBuilder", "constructor"})
        Builder(CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder, BiFunction<ProfilerParameters, ProfilerFinalParameters, ProfilerWithPause> constructor) {
            this.codeGuruClientBuilder = codeGuruClientBuilder;
            this.constructor = constructor;
        }
    }
}

