/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.KillSwitch;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.MemoryProfilerParameters;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.Timer;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.flightrecorder.AllocationEventProcessor;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.flightrecorder.MemoryProfiler;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.flightrecorder.ObjectCountEventProcessor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ProfilingCommandExecutor
implements ProfilingCommands {
    private static final Logger LOG = Logger.getLogger(ProfilingCommandExecutor.class.getName());
    protected ScheduledExecutorService executor;
    protected ScheduledFuture<?> futureSampleTask;
    protected volatile boolean isTerminated = false;
    protected final Timer overheadTimer = new Timer();
    protected final KillSwitch killSwitch = new KillSwitch();
    protected final MemoryProfiler memoryProfiler;

    public ProfilingCommandExecutor(MemoryProfilerParameters memoryProfilerParameters) {
        this.memoryProfiler = this.buildMemoryProfiler(memoryProfilerParameters);
    }

    @Override
    public void run() {
        this.overheadTimer.time(this::startSampling, Timer.ProfilingTimes.runProfiler);
    }

    @Override
    public void scheduleProfiling() {
        if (this.isTerminated) {
            LOG.info("ProfilingCommand cannot be started again, create another instance instead");
            return;
        }
        if (this.isProfilingDisabled()) {
            return;
        }
        this.setProfilingScheduledExecutor();
        Duration samplingInterval = this.getParameters().getSamplingInterval();
        this.scheduleTaskInExecutor(samplingInterval, samplingInterval);
        LOG.info("Profiling scheduled, sampling rate is " + samplingInterval);
    }

    private void setProfilingScheduledExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread2 = new Thread(r, "Amazon-Profiler");
                thread2.setDaemon(true);
                thread2.interrupt();
                return thread2;
            });
        }
    }

    @Override
    public void stopProfiling() {
        this.isTerminated = true;
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "InterruptedException received while waiting for executor to terminate.");
            }
            finally {
                this.futureSampleTask = null;
                this.executor = null;
            }
        }
        this.overheadTimer.time(() -> this.flush(true), Timer.ProfilingTimes.flush);
        this.memoryProfiler.stopRecording();
    }

    @Override
    public CompletableFuture<Void> asyncStopProfiling() {
        this.isTerminated = true;
        return CompletableFuture.runAsync(this::stopProfiling);
    }

    @Override
    public boolean isProfilingScheduled() {
        return this.executor != null && !this.isTerminated;
    }

    protected final void scheduleTaskInExecutor(Duration initialDelay, Duration delay) {
        if (this.executor != null) {
            this.cancelTaskInExecutor();
            this.futureSampleTask = this.executor.scheduleWithFixedDelay(this, initialDelay.toNanos(), delay.toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    protected final void cancelTaskInExecutor() {
        if (this.futureSampleTask != null) {
            this.futureSampleTask.cancel(false);
            this.futureSampleTask = null;
        }
    }

    protected final void waitAndCancelTaskInExecutor(long waitTimeInMs) {
        if (this.futureSampleTask != null) {
            try {
                this.futureSampleTask.get(waitTimeInMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Exception received while waiting for task to complete.", e);
            }
            finally {
                this.cancelTaskInExecutor();
            }
        }
    }

    private MemoryProfiler buildMemoryProfiler(MemoryProfilerParameters parameters) {
        boolean isEnabled = parameters.getAllocationProfilingEnabled() || parameters.getHeapSummaryEnabled();
        ArrayList<EventProcessor> eventProcessors = new ArrayList<EventProcessor>();
        if (parameters.getHeapSummaryEnabled()) {
            eventProcessors.add(new ObjectCountEventProcessor());
        }
        if (parameters.getAllocationProfilingEnabled()) {
            eventProcessors.add(new AllocationEventProcessor());
        }
        return new MemoryProfiler(isEnabled, eventProcessors);
    }

    private boolean isProfilingDisabled() {
        if (this.killSwitch.isKillSwitchOn(true)) {
            LOG.info("Disabling the profiler as the kill switch file has been found");
            return true;
        }
        return false;
    }

    abstract void flush(boolean var1);

    abstract ProfilerParameters getParameters();

    abstract ProfilerFinalParameters getFinalParameters();
}

