/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.Counter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

class Timer {
    public static final String TIMINGS_SUFFIX = "_timings";
    private final Map<String, Counter> profilingTimes = new HashMap<String, Counter>();

    Timer() {
        for (ProfilingTimes method : ProfilingTimes.values()) {
            this.profilingTimes.put(method.name() + TIMINGS_SUFFIX, new Counter());
        }
    }

    Map<String, Counter> getProfilingTimes() {
        return this.profilingTimes;
    }

    void reset() {
        for (Counter counter : this.profilingTimes.values()) {
            counter.reset();
        }
    }

    <T> T time(Callable<T> task, ProfilingTimes methodName) {
        T result;
        long startTime = System.nanoTime();
        try {
            result = task.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred during profiling: ", e);
        }
        long endTime = System.nanoTime();
        this.recordInvocationTime(methodName, endTime - startTime);
        return result;
    }

    void time(Runnable task, ProfilingTimes methodName) {
        long startTime = System.nanoTime();
        task.run();
        long endTime = System.nanoTime();
        this.recordInvocationTime(methodName, endTime - startTime);
    }

    private void recordInvocationTime(ProfilingTimes method, long timeTakenNanos) {
        String methodName = method.name() + TIMINGS_SUFFIX;
        this.profilingTimes.get(methodName).count(timeTakenNanos);
    }

    public static enum ProfilingTimes {
        runProfiler,
        flush,
        flushMemoryProfiler,
        dumpAllStackTraces,
        aggregateThreadDumps,
        captureProfilerProcessing,
        captureGarbageCollection,
        submitProfilingData,
        runControl,
        startProfilingCommand,
        sendAutoEnrollCall,
        sendAgentConfigCall,
        applyProfilingConfiguration,
        resetAgentConfigSchedule,
        updateSamplingConfig;

    }
}

