/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.jvmagent;

import codegurushadow.software.amazon.awssdk.regions.Region;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilingArguments;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;

public class LambdaJvmArgumentParser {
    private static final Logger LOG = Logger.getLogger(LambdaJvmArgumentParser.class.getName());
    public static final String DEFAULT_AWS_LAMBDA_PROFILING_GROUP_NAME = "aws-lambda-%s";
    private final Function<String, String> environment;

    LambdaJvmArgumentParser(Function<String, String> environment) {
        this.environment = environment;
    }

    void configureProfilerBuilder(ProfilerWithPause.Builder builder) {
        builder.integrationModeStandalone();
        this.getProfilingGroupName().ifPresent(builder::profilingGroupName);
        this.getRegion().ifPresent(builder::awsRegionToReportTo);
        this.getHeapSummaryEnabled().ifPresent(builder::withHeapSummary);
        LOG.info(String.format("CodeGuru profiling group: %s in AWS region: %s will be used for profiling your lambda function", builder.getProfilingGroupName(), builder.getAwsRegion()));
    }

    Optional<String> getProfilingGroupName() {
        Optional<String> value = ProfilingArguments.PROFILING_GROUP_NAME.readArgument(this.environment);
        if (value.isPresent()) {
            return value;
        }
        String lambdaFunctionName = this.environment.apply("AWS_LAMBDA_FUNCTION_NAME");
        if (lambdaFunctionName != null) {
            String defaultProfilingGroupName = String.format(DEFAULT_AWS_LAMBDA_PROFILING_GROUP_NAME, lambdaFunctionName);
            LOG.info(String.format("Could not find a profiling group name from environment variable %s. Using default profiling group name %s", ProfilingArguments.PROFILING_GROUP_NAME.environmentVariableName, defaultProfilingGroupName));
            return Optional.of(defaultProfilingGroupName);
        }
        throw new RuntimeException("Could not find a profiling group name to start the CodeGuru Profiler agent. Add environment variable " + ProfilingArguments.PROFILING_GROUP_NAME.environmentVariableName + " to set it.");
    }

    Optional<Region> getRegion() {
        return ProfilingArguments.REGION.readArgument(this.environment).map(Region::of);
    }

    Optional<Boolean> getHeapSummaryEnabled() {
        return ProfilingArguments.HEAP_SUMMARY_ENABLED.readArgument(this.environment).map(Boolean::parseBoolean);
    }
}

