/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.jvmagent;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.IProfiler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProfilerShutdownHook
extends Thread {
    private static final Logger LOG = Logger.getLogger(ProfilerShutdownHook.class.getName());
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_SEC = 2L;
    private final IProfiler profiler;
    private final long shutdownTimeoutSec;
    private final FutureTask<Void> stopFuture;
    private final Thread stopThread;

    ProfilerShutdownHook(IProfiler profiler) {
        this(profiler, 2L);
    }

    ProfilerShutdownHook(IProfiler profiler, long shutdownTimeoutSec) {
        super(ProfilerShutdownHook.class.getName());
        this.profiler = profiler;
        this.shutdownTimeoutSec = shutdownTimeoutSec;
        this.stopFuture = new FutureTask<Void>(() -> {
            profiler.stop();
            return null;
        });
        this.stopThread = new Thread(this.stopFuture);
        this.stopThread.setDaemon(true);
    }

    @Override
    public void run() {
        LOG.info("Stopping Profiler as part of the JVM shutdown sequence.");
        this.stopThread.start();
        try {
            LOG.info(String.format("Waiting for %s seconds for Profiler shutdown.", String.valueOf(this.shutdownTimeoutSec)));
            this.stopFuture.get(this.shutdownTimeoutSec, TimeUnit.SECONDS);
            LOG.info("Profiler stopped gracefully.");
        }
        catch (InterruptedException e) {
            LOG.info("Profiler shutdown interrupted. Some profiling data may have been lost.");
        }
        catch (ExecutionException e) {
            LOG.log(Level.INFO, "Profiler shutdown interrupted with an exception. Some profiling data may have been lost. Details:", e.getCause());
        }
        catch (TimeoutException e) {
            LOG.info("Profiler shutdown timed out. Some profiling data may have been lost.");
        }
    }
}

