/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.profile;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.CallGraphBuilder;
import java.util.Arrays;

public class CallGraph {
    private static final int REFERENCE_SIZE = 4;
    private static final int INITIAL_SIZE = 32;
    private static final int LONG_SIZE = 8;
    private static final int ARRAY_OVERHEAD_SIZE = 24;
    private static final long[] EMPTY_COUNTS = new long[0];
    private static final CallGraph[] EMPTY_CHIDREN = new CallGraph[0];
    private final int frame;
    private long[] counts;
    private CallGraph[] children;
    private boolean hasCounts;

    CallGraph(int frame, CallGraphBuilder.Counter memoryCounter) {
        this.frame = frame;
        this.counts = EMPTY_COUNTS;
        this.children = EMPTY_CHIDREN;
        this.hasCounts = false;
        memoryCounter.add(32L);
    }

    CallGraph addChild(int childFrame, CallGraphBuilder.Counter memoryCounter) {
        int insertionPoint = 0;
        int position = Arrays.binarySearch(this.children, null, (o1, o2) -> Integer.compare(o1.frame, childFrame));
        this.hasCounts = true;
        if (position >= 0) {
            return this.children[position];
        }
        insertionPoint = -(position + 1);
        CallGraph childNode = new CallGraph(childFrame, memoryCounter);
        if (this.children.length == 0) {
            memoryCounter.add(24L);
        }
        this.addChild(insertionPoint, childNode);
        memoryCounter.add(4L);
        return childNode;
    }

    private void addChild(int position, CallGraph childNode) {
        CallGraph[] newChildren = new CallGraph[this.children.length + 1];
        newChildren[position] = childNode;
        System.arraycopy(this.children, 0, newChildren, 0, position);
        if (position < this.children.length) {
            System.arraycopy(this.children, position, newChildren, position + 1, this.children.length - position);
        }
        this.children = newChildren;
    }

    void addCount(int stateEncoding, long count, CallGraphBuilder.Counter memoryCounter) {
        if (stateEncoding >= this.counts.length) {
            if (this.counts.length == 0) {
                memoryCounter.add(24L);
            }
            int newCountsLength = stateEncoding + 1;
            memoryCounter.add((newCountsLength - this.counts.length) * 8);
            this.counts = Arrays.copyOf(this.counts, newCountsLength);
        }
        int n = stateEncoding;
        this.counts[n] = this.counts[n] + count;
        this.hasCounts = true;
    }

    CallGraph[] getChildren() {
        return this.children;
    }

    int getFrame() {
        return this.frame;
    }

    long[] getCounts() {
        return this.counts;
    }

    boolean hasCounts() {
        return this.hasCounts;
    }

    void resetCounts() {
        Arrays.fill(this.counts, 0L);
        this.hasCounts = false;
        for (CallGraph child : this.children) {
            child.resetCounts();
        }
    }
}

