/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.profile;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.CallGraph;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.FrameEncodings;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.MemoryCounter;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.StateEncodings;

public class CallGraphBuilder {
    private static final String BASE_FRAME_NAME = "ALL";
    private static final String TRUNCATED_FRAME_NAME = "<Truncated>";
    private final FrameEncodings frameEncodings;
    private final CallGraph syntheticRoot;
    private final int maxStackDepth;
    private final Counter callGraphMemoryCounter;

    public CallGraphBuilder() {
        this(Integer.MAX_VALUE);
    }

    public CallGraphBuilder(int maxStackDepth) {
        this.maxStackDepth = maxStackDepth;
        this.frameEncodings = new FrameEncodings();
        this.callGraphMemoryCounter = new Counter();
        this.syntheticRoot = new CallGraph(this.frameEncodings.encode(BASE_FRAME_NAME, ""), this.callGraphMemoryCounter);
    }

    public void resetCounters() {
        this.syntheticRoot.resetCounts();
    }

    public void capture(Thread.State state, StackTraceElement ... stackTrace) {
        this.capture(state, 1, false, stackTrace);
    }

    public void capture(Thread.State state, boolean inNative, StackTraceElement ... stackTrace) {
        this.capture(state, 1, inNative, stackTrace);
    }

    public void capture(Thread.State state, int count, StackTraceElement ... stackTrace) {
        this.capture(state, count, false, stackTrace);
    }

    public void capture(MemoryCounter memoryCounter, int count, StackTraceElement ... stackTrace) {
        int stateEncoding = StateEncodings.getStateEncoding(memoryCounter);
        this.updateCallGraph(stateEncoding, count, stackTrace);
    }

    public void capture(Thread.State state, int count, boolean inNative, StackTraceElement ... stackTrace) {
        int stateEncoding = inNative ? StateEncodings.getNativeStateEncoding() : StateEncodings.getStateEncoding(state);
        this.updateCallGraph(stateEncoding, count, stackTrace);
    }

    private void updateCallGraph(int stateEncoding, int count, StackTraceElement ... stackTrace) {
        int stackTraceLength;
        int n = stackTraceLength = stackTrace.length > this.maxStackDepth ? this.maxStackDepth : stackTrace.length;
        if (stackTraceLength == 0) {
            return;
        }
        if (stateEncoding < 0) {
            return;
        }
        CallGraph node = this.syntheticRoot;
        if (stackTraceLength == this.maxStackDepth) {
            int truncatedEncoding = this.frameEncodings.encode(TRUNCATED_FRAME_NAME, "");
            node = node.addChild(truncatedEncoding, this.callGraphMemoryCounter);
            --stackTraceLength;
        }
        for (int i = stackTraceLength - 1; i >= 0; --i) {
            int encoding = this.frameEncodings.encode(stackTrace[i].getClassName(), stackTrace[i].getMethodName());
            node = node.addChild(encoding, this.callGraphMemoryCounter);
        }
        node.addCount(stateEncoding, count, this.callGraphMemoryCounter);
    }

    public long getSizeInMemory() {
        return this.callGraphMemoryCounter.getCount() + this.frameEncodings.getSizeInMemory();
    }

    public CallGraph getCallGraph() {
        return this.syntheticRoot;
    }

    public FrameEncodings getFrameEncodings() {
        return this.frameEncodings;
    }

    static class Counter {
        private long count;

        Counter() {
        }

        void add(long size) {
            this.count += size;
        }

        long getCount() {
            return this.count;
        }
    }
}

