/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.profile;

import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.HeapSettings;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class HeapSnapshot {
    private static final int MAX_CLASS_SUMMARIES = 100;
    private final List<ClassSummary> classSummaries;
    private final Instant captureTimestamp;
    private final long uptimeMillis;
    private final Long heapUsedBytes;
    private final HeapSettings settings;

    public HeapSnapshot(Instant captureTimestamp, long uptimeMillis, HeapSettings settings, Long heapUsedBytes, List<ClassSummary> classSummaries) {
        this.classSummaries = this.limitSize(classSummaries, 100);
        this.captureTimestamp = captureTimestamp;
        this.uptimeMillis = uptimeMillis;
        this.settings = settings;
        this.heapUsedBytes = heapUsedBytes;
    }

    public HeapSettings getSettings() {
        return this.settings;
    }

    public Long getHeapUsedBytes() {
        return this.heapUsedBytes;
    }

    public long getUptimeMillis() {
        return this.uptimeMillis;
    }

    public Instant getCaptureTimestamp() {
        return this.captureTimestamp;
    }

    public List<ClassSummary> getClassSummaries() {
        return this.classSummaries;
    }

    private List<ClassSummary> limitSize(List<ClassSummary> input, int maxElements) {
        if (input.size() <= maxElements) {
            return input;
        }
        return input.stream().sorted(Comparator.comparing(ClassSummary::getObjectSizeBytes).reversed()).limit(maxElements).collect(Collectors.toList());
    }
}

