/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata;

import codegurushadow.com.amazon.ion.IonReader;
import codegurushadow.com.amazon.ion.IonSystem;
import codegurushadow.com.amazon.ion.IonType;
import codegurushadow.com.amazon.ion.system.IonSystemBuilder;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata.AWSFargateTask;
import codegurushadow.software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FargateMetadataFetcher {
    private static final Logger LOG = Logger.getLogger(FargateMetadataFetcher.class.getName());
    private static final IonSystem ION_SYSTEM = IonSystemBuilder.standard().build();
    private static final String ECS_CONTAINER_METADATA_URI = "ECS_CONTAINER_METADATA_URI";
    private static final String TASK_ARN = "TaskARN";
    private static final String LIMITS = "Limits";
    private static final String CPU_LIMIT = "CPU";
    private static final String MEMORY_LIMIT = "Memory";
    private final String json;
    private String taskArn;
    private double cpuLimit;
    private long memoryLimit;

    public FargateMetadataFetcher(ErrorsMetadata errorsMetadata) {
        this(FargateMetadataFetcher.getJsonFromEcsMetadata(errorsMetadata));
    }

    FargateMetadataFetcher(String json) {
        this.json = json;
        this.parseJson();
    }

    public AWSFargateTask getMetadata() {
        if (this.taskArn == null) {
            return null;
        }
        return new AWSFargateTask(this.taskArn, this.cpuLimit, this.memoryLimit);
    }

    private static String getJsonFromEcsMetadata(ErrorsMetadata errorsMetadata) {
        try {
            String urlPath = System.getenv(ECS_CONTAINER_METADATA_URI) + "/task";
            URL url = new URL(urlPath);
            return FargateMetadataFetcher.getJsonFromEcsMetadata(url, errorsMetadata);
        }
        catch (Exception e) {
            errorsMetadata.recordFargate(LOG, Level.INFO, "Unable to build URL to get ECS metadata, this is normal when running in a different environment (e.g. local dev machine), profiler will still work: " + e.getMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJsonFromEcsMetadata(URL url, ErrorsMetadata errorsMetadata) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
            String string = reader.readLine();
            return string;
        }
        catch (Exception e) {
            errorsMetadata.recordFargate(LOG, Level.INFO, "Unable to read json from ECS metadata, this is normal when running in a different environment (e.g. local dev machine), profiler will still work: " + e.getMessage());
            return "";
        }
    }

    private void parseJson() {
        if (this.json.isEmpty()) {
            return;
        }
        try {
            IonReader reader = ION_SYSTEM.newReader(this.json.getBytes(StandardCharsets.UTF_8));
            if (reader.next() == IonType.STRUCT && !reader.isNullValue()) {
                reader.stepIn();
                this.parseValues(reader);
                reader.stepOut();
            }
            reader.close();
        }
        catch (Exception e) {
            LOG.info("Unable to parse JSON for ECS metadata: " + e.getMessage());
        }
    }

    private void parseValues(IonReader reader) {
        while (reader.next() != null) {
            if (reader.getFieldName().equals(TASK_ARN) && reader.getType() == IonType.STRING) {
                this.taskArn = reader.stringValue();
                continue;
            }
            if (!reader.getFieldName().equals(LIMITS) || reader.getType() != IonType.STRUCT || reader.isNullValue()) continue;
            this.parseLimits(reader);
        }
    }

    private void parseLimits(IonReader reader) {
        reader.stepIn();
        while (reader.next() != null) {
            if (reader.getFieldName().equals(CPU_LIMIT)) {
                if (reader.getType() == IonType.INT) {
                    this.cpuLimit = reader.intValue();
                    continue;
                }
                if (reader.getType() != IonType.DECIMAL) continue;
                this.cpuLimit = reader.doubleValue();
                continue;
            }
            if (!reader.getFieldName().equals(MEMORY_LIMIT) || reader.getType() != IonType.INT) continue;
            this.memoryLimit = reader.intValue();
        }
        reader.stepOut();
    }
}

