// Class __default
// Dafny class __default compiled into Java
package AlgorithmSuites_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class __default {
  public __default() {
  }
  public static boolean SupportedESDKEncrypt_q(software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt e) {
    return (((true) && ((((((e).dtor_AES__GCM()).dtor_keyLength()) == (32)) || ((((e).dtor_AES__GCM()).dtor_keyLength()) == (24))) || ((((e).dtor_AES__GCM()).dtor_keyLength()) == (16)))) && ((((e).dtor_AES__GCM()).dtor_tagLength()) == (16))) && ((((e).dtor_AES__GCM()).dtor_ivLength()) == (12));
  }
  public static boolean SupportedDBEEncrypt_q(software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt e) {
    return (((true) && ((((e).dtor_AES__GCM()).dtor_keyLength()) == (32))) && ((((e).dtor_AES__GCM()).dtor_tagLength()) == (16))) && ((((e).dtor_AES__GCM()).dtor_ivLength()) == (12));
  }
  public static boolean SupportedDBEEDKWrapping_q(software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm p) {
    return (((((((p).is_IntermediateKeyWrapping()) && (true)) && ((((((p).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && ((((((p).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_tagLength()) == (16))) && ((((((p).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_ivLength()) == (12))) && ((((p).dtor_IntermediateKeyWrapping()).dtor_macKeyKdf()).is_HKDF())) && ((((p).dtor_IntermediateKeyWrapping()).dtor_keyEncryptionKeyKdf()).is_HKDF());
  }
  public static boolean KeyDerivationAlgorithm_q(software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm kdf) {
    return (!((true) && ((kdf).is_HKDF())) || (((((kdf).dtor_HKDF()).dtor_inputKeyLength()) == (((kdf).dtor_HKDF()).dtor_outputKeyLength())) && (!(java.util.Objects.equals(((kdf).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512())) || ((((kdf).dtor_HKDF()).dtor_inputKeyLength()) == (32))))) && (!((kdf).is_None()));
  }
  public static boolean CommitmentDerivationAlgorithm_q(software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm kdf) {
    return (!((true) && ((kdf).is_HKDF())) || (((((((kdf).dtor_HKDF()).dtor_hmac()).is_SHA__512()) && ((((kdf).dtor_HKDF()).dtor_saltLength()) == (32))) && ((((kdf).dtor_HKDF()).dtor_inputKeyLength()) == (32))) && ((((kdf).dtor_HKDF()).dtor_outputKeyLength()) == (32)))) && (!((kdf).is_IDENTITY()));
  }
  public static boolean EdkWrappingAlgorithm_q(software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm alg) {
    return ((((((alg).is_IntermediateKeyWrapping()) && ((((alg).dtor_IntermediateKeyWrapping()).dtor_keyEncryptionKeyKdf()).is_HKDF())) && ((((alg).dtor_IntermediateKeyWrapping()).dtor_macKeyKdf()).is_HKDF())) && (true)) && ((((((alg).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_keyLength()) == (32))) || ((alg).is_DIRECT__KEY__WRAPPING());
  }
  public static boolean AlgorithmSuiteInfo_q(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    return ((((((((__default.KeyDerivationAlgorithm_q((a).dtor_kdf())) && (__default.CommitmentDerivationAlgorithm_q((a).dtor_commitment()))) && (__default.EdkWrappingAlgorithm_q((a).dtor_edkWrapping()))) && (!(((a).dtor_kdf()).is_HKDF()) || ((true) && (((((a).dtor_kdf()).dtor_HKDF()).dtor_outputKeyLength()) == ((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()))))) && (!(((a).dtor_signature()).is_ECDSA()) || (((a).dtor_kdf()).is_HKDF()))) && (!(((a).dtor_commitment()).is_HKDF()) || ((((((a).dtor_commitment()).dtor_HKDF()).dtor_saltLength()) == (32)) && (java.util.Objects.equals((a).dtor_commitment(), (a).dtor_kdf()))))) && (!(((a).dtor_edkWrapping()).is_IntermediateKeyWrapping()) || (((((a).dtor_kdf()).is_HKDF()) && (java.util.Objects.equals((((a).dtor_edkWrapping()).dtor_IntermediateKeyWrapping()).dtor_keyEncryptionKeyKdf(), (a).dtor_kdf()))) && (java.util.Objects.equals((((a).dtor_edkWrapping()).dtor_IntermediateKeyWrapping()).dtor_macKeyKdf(), (a).dtor_kdf()))))) && (!((((a).dtor_kdf()).is_HKDF()) && (((a).dtor_commitment()).is_None())) || (java.lang.Integer.signum(((((a).dtor_kdf()).dtor_HKDF()).dtor_saltLength())) == 0))) && (!(!(((a).dtor_symmetricSignature()).is_None())) || ((true) && (((a).dtor_edkWrapping()).is_IntermediateKeyWrapping())));
  }
  public static boolean ESDKAlgorithmSuite_q(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    return ((__default.AlgorithmSuiteInfo_q(a)) && (__default.SupportedESDKEncrypt_q((a).dtor_encrypt()))) && (((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId, Boolean>)(_source10_boxed0) -> {
      software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId _source10 = ((software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId)(java.lang.Object)(_source10_boxed0));
      if (_source10.is_ALG__AES__128__GCM__IV12__TAG16__NO__KDF()) {
        return ((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 0, (byte) 20))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (16))) && (((a).dtor_kdf()).is_IDENTITY())) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__192__GCM__IV12__TAG16__NO__KDF()) {
        return ((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 0, (byte) 70))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (24))) && (((a).dtor_kdf()).is_IDENTITY())) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__256__GCM__IV12__TAG16__NO__KDF()) {
        return ((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 0, (byte) 120))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_IDENTITY())) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()) {
        return (((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 1, (byte) 20))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (16))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256()))) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()) {
        return (((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 1, (byte) 70))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (24))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256()))) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()) {
        return (((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 1, (byte) 120))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256()))) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()) {
        return ((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 2, (byte) 20))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (16))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256()))) && (((a).dtor_signature()).is_ECDSA())) && (java.util.Objects.equals((((a).dtor_signature()).dtor_ECDSA()).dtor_curve(), software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P256()))) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()) {
        return ((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 3, (byte) 70))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (24))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()))) && (((a).dtor_signature()).is_ECDSA())) && (java.util.Objects.equals((((a).dtor_signature()).dtor_ECDSA()).dtor_curve(), software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384()))) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()) {
        return ((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 3, (byte) 120))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()))) && (((a).dtor_signature()).is_ECDSA())) && (java.util.Objects.equals((((a).dtor_signature()).dtor_ECDSA()).dtor_curve(), software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384()))) && (((a).dtor_commitment()).is_None())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else if (_source10.is_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()) {
        return (((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 4, (byte) 120))) && (((a).dtor_messageVersion()) == (2))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512()))) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_HKDF())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      } else {
        return ((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 5, (byte) 120))) && (((a).dtor_messageVersion()) == (2))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512()))) && (((a).dtor_signature()).is_ECDSA())) && (java.util.Objects.equals((((a).dtor_signature()).dtor_ECDSA()).dtor_curve(), software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384()))) && (((a).dtor_commitment()).is_HKDF())) && (((a).dtor_symmetricSignature()).is_None())) && (((a).dtor_edkWrapping()).is_DIRECT__KEY__WRAPPING());
      }
    }).apply(((a).dtor_id()).dtor_ESDK()));
  }
  public static boolean DBEAlgorithmSuite_q(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    return (((__default.AlgorithmSuiteInfo_q(a)) && (__default.SupportedDBEEncrypt_q((a).dtor_encrypt()))) && (__default.SupportedDBEEDKWrapping_q((a).dtor_edkWrapping()))) && (((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId, Boolean>)(_source11_boxed0) -> {
      software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId _source11 = ((software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId)(java.lang.Object)(_source11_boxed0));
      if (_source11.is_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()) {
        return ((((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 103, (byte) 0))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512()))) && (((a).dtor_signature()).is_None())) && (((a).dtor_commitment()).is_HKDF())) && (((a).dtor_symmetricSignature()).is_HMAC())) && (java.util.Objects.equals(((a).dtor_symmetricSignature()).dtor_HMAC(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()))) && (((a).dtor_edkWrapping()).is_IntermediateKeyWrapping())) && (true)) && (((((((a).dtor_edkWrapping()).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_keyLength()) == (32));
      } else {
        return (((((((((((((((a).dtor_binaryId()).equals(dafny.DafnySequence.of((byte) 103, (byte) 1))) && (((a).dtor_messageVersion()) == (1))) && (true)) && (((((a).dtor_encrypt()).dtor_AES__GCM()).dtor_keyLength()) == (32))) && (((a).dtor_kdf()).is_HKDF())) && (java.util.Objects.equals((((a).dtor_kdf()).dtor_HKDF()).dtor_hmac(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512()))) && (((a).dtor_signature()).is_ECDSA())) && (java.util.Objects.equals((((a).dtor_signature()).dtor_ECDSA()).dtor_curve(), software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384()))) && (((a).dtor_commitment()).is_HKDF())) && (((a).dtor_symmetricSignature()).is_HMAC())) && (java.util.Objects.equals(((a).dtor_symmetricSignature()).dtor_HMAC(), software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()))) && (((a).dtor_edkWrapping()).is_IntermediateKeyWrapping())) && (true)) && (((((((a).dtor_edkWrapping()).dtor_IntermediateKeyWrapping()).dtor_pdkEncryptAlgorithm()).dtor_AES__GCM()).dtor_keyLength()) == (32));
      }
    }).apply(((a).dtor_id()).dtor_DBE()));
  }
  public static boolean AlgorithmSuite_q(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId _source12 = (a).dtor_id();
    if (_source12.is_ESDK()) {
      software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId _305___mcc_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_ESDK)_source12)._ESDK;
      return __default.ESDKAlgorithmSuite_q(a);
    } else {
      software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId _306___mcc_h1 = ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_DBE)_source12)._DBE;
      return __default.DBEAlgorithmSuite_q(a);
    }
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm HKDF__SHA__256(int keyLength) {
    return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_HKDF(software.amazon.cryptography.materialproviders.internaldafny.types.HKDF.create(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256(), 0, keyLength, keyLength));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm HKDF__SHA__384(int keyLength) {
    return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_HKDF(software.amazon.cryptography.materialproviders.internaldafny.types.HKDF.create(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384(), 0, keyLength, keyLength));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm HKDF__SHA__512(int keyLength) {
    return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_HKDF(software.amazon.cryptography.materialproviders.internaldafny.types.HKDF.create(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512(), 32, keyLength, keyLength));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo GetSuite(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId id) {
    software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId _source13 = id;
    if (_source13.is_ESDK()) {
      software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId _307___mcc_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_ESDK)_source13)._ESDK;
      software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId _308_e = _307___mcc_h0;
      return __default.GetESDKSuite(_308_e);
    } else {
      software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId _309___mcc_h1 = ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_DBE)_source13)._DBE;
      software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId _310_e = _309___mcc_h1;
      return __default.GetDBESuite(_310_e);
    }
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo GetDBESuite(software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId id) {
    return ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo)(java.lang.Object)((__default.SupportedDBEAlgorithmSuites()).get(id)));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo GetESDKSuite(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId id) {
    return ((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo)(java.lang.Object)((__default.SupportedESDKAlgorithmSuites()).get(id)));
  }
  public static int GetEncryptKeyLength(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt _source14 = (a).dtor_encrypt();
    {
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _311___mcc_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt)_source14)._AES__GCM;
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _312_e = _311___mcc_h0;
      return (_312_e).dtor_keyLength();
    }
  }
  public static int GetEncryptTagLength(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt _source15 = (a).dtor_encrypt();
    {
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _313___mcc_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt)_source15)._AES__GCM;
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _314_e = _313___mcc_h0;
      return (_314_e).dtor_tagLength();
    }
  }
  public static int GetEncryptIvLength(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo a) {
    software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt _source16 = (a).dtor_encrypt();
    {
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _315___mcc_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt)_source16)._AES__GCM;
      software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _316_e = _315___mcc_h0;
      return (_316_e).dtor_ivLength();
    }
  }
  public static Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetAlgorithmSuiteInfo(dafny.DafnySequence<? extends java.lang.Byte> binaryId_q) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _317_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (__default.AlgorithmSuiteInfoByBinaryId()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(binaryId_q), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Invalid BinaryId")));
    if ((_317_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      return (_317_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AlgorithmSuite._typeDescriptor());
    } else {
      return Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(((software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo)(java.lang.Object)((__default.AlgorithmSuiteInfoByBinaryId()).get(binaryId_q))));
    }
  }
  public static int Bits128()
  {
    return 16;
  }
  public static int TagLen()
  {
    return 16;
  }
  public static int IvLen()
  {
    return 12;
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt AES__128__GCM__IV12__TAG16()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt.create(software.amazon.cryptography.primitives.internaldafny.types.AES__GCM.create(__default.Bits128(), __default.TagLen(), __default.IvLen()));
  }
  public static int Bits192()
  {
    return 24;
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt AES__192__GCM__IV12__TAG16()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt.create(software.amazon.cryptography.primitives.internaldafny.types.AES__GCM.create(__default.Bits192(), __default.TagLen(), __default.IvLen()));
  }
  public static int Bits256()
  {
    return 32;
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt AES__256__GCM__IV12__TAG16()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt.create(software.amazon.cryptography.primitives.internaldafny.types.AES__GCM.create(__default.Bits256(), __default.TagLen(), __default.IvLen()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_IntermediateKeyWrapping(software.amazon.cryptography.materialproviders.internaldafny.types.IntermediateKeyWrapping.create(__default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), __default.AES__256__GCM__IV12__TAG16()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_DBE(software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), dafny.DafnySequence.of((byte) 103, (byte) 0), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_HMAC(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()), __default.EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512());
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_DBE(software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384()), dafny.DafnySequence.of((byte) 103, (byte) 1), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_ECDSA(software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA.create(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384())), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_HMAC(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384()), __default.EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512());
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), dafny.DafnySequence.of((byte) 0, (byte) 20), 1, __default.AES__128__GCM__IV12__TAG16(), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_IDENTITY(software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY.create()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), dafny.DafnySequence.of((byte) 0, (byte) 70), 1, __default.AES__192__GCM__IV12__TAG16(), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_IDENTITY(software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY.create()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), dafny.DafnySequence.of((byte) 0, (byte) 120), 1, __default.AES__256__GCM__IV12__TAG16(), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_IDENTITY(software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY.create()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), dafny.DafnySequence.of((byte) 1, (byte) 20), 1, __default.AES__128__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits128()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), dafny.DafnySequence.of((byte) 1, (byte) 70), 1, __default.AES__192__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits192()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), dafny.DafnySequence.of((byte) 1, (byte) 120), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), dafny.DafnySequence.of((byte) 2, (byte) 20), 1, __default.AES__128__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits128()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_ECDSA(software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA.create(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P256())), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), dafny.DafnySequence.of((byte) 3, (byte) 70), 1, __default.AES__192__GCM__IV12__TAG16(), __default.HKDF__SHA__384(__default.Bits192()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_ECDSA(software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA.create(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384())), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), dafny.DafnySequence.of((byte) 3, (byte) 120), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__384(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_ECDSA(software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA.create(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384())), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), dafny.DafnySequence.of((byte) 4, (byte) 120), 2, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()
  {
    return software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo.create(software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.create_ESDK(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()), dafny.DafnySequence.of((byte) 5, (byte) 120), 2, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.create_ECDSA(software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA.create(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.create_ECDSA__P384())), software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.create_None(software.amazon.cryptography.materialproviders.internaldafny.types.None.create()), software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING.create()));
  }
  public static dafny.DafnyMap<? extends software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId, ? extends software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo> SupportedESDKAlgorithmSuites()
  {
    return dafny.DafnyMap.fromElements(new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__NO__KDF(), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__NO__KDF(), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__NO__KDF(), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256(), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256(), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256(), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256(), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384(), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384(), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY(), __default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384(), __default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()));
  }
  public static dafny.DafnyMap<? extends software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId, ? extends software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo> SupportedDBEAlgorithmSuites()
  {
    return dafny.DafnyMap.fromElements(new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384(), __default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), new dafny.Tuple2(software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384(), __default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384()));
  }
  public static dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo> AlgorithmSuiteInfoByBinaryId()
  {
    return dafny.DafnyMap.fromElements(new dafny.Tuple2(dafny.DafnySequence.of((byte) 0, (byte) 20), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 0, (byte) 70), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 0, (byte) 120), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 1, (byte) 20), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 1, (byte) 70), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 1, (byte) 120), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 2, (byte) 20), __default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 3, (byte) 70), __default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 3, (byte) 120), __default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 4, (byte) 120), __default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 5, (byte) 120), __default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 103, (byte) 0), __default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), new dafny.Tuple2(dafny.DafnySequence.of((byte) 103, (byte) 1), __default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384()));
  }
  @Override
  public java.lang.String toString() {
    return "AlgorithmSuites._default";
  }
}
