// Class __default
// Dafny class __default compiled into Java
package AwsArnParsing_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class __default {
  public __default() {
  }
  public static boolean ValidAwsKmsResource(AwsResource resource) {
    return ((resource).Valid()) && ((((resource).dtor_resourceType()).equals(dafny.DafnySequence.asString("key"))) || (((resource).dtor_resourceType()).equals(dafny.DafnySequence.asString("alias"))));
  }
  public static boolean ValidAwsKmsArn(AwsArn arn) {
    return (((arn).Valid()) && (((arn).dtor_service()).equals(dafny.DafnySequence.asString("kms")))) && (__default.ValidAwsKmsResource((arn).dtor_resource()));
  }
  public static Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> ParseAwsKmsRawResources(dafny.DafnySequence<? extends Character> identifier) {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _0_info = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, identifier, '/');
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _1_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), !(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_0_info).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).equals(dafny.DafnySequence.asString("key")), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed raw key id: "), identifier));
    if ((_1_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_1_valueOrError0).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsKmsResource._typeDescriptor());
    } else if (java.util.Objects.equals(java.math.BigInteger.valueOf((_0_info).length()), java.math.BigInteger.ONE)) {
      return __default.ParseAwsKmsResources(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("key/"), identifier));
    } else {
      return __default.ParseAwsKmsResources(identifier);
    }
  }
  public static Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> ParseAwsKmsResources(dafny.DafnySequence<? extends Character> identifier) {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _2_info = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, identifier, '/');
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _3_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), (java.math.BigInteger.valueOf((_2_info).length())).compareTo(java.math.BigInteger.ONE) > 0, dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed resource: "), identifier));
    if ((_3_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_3_valueOrError0).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsResource._typeDescriptor());
    } else {
      dafny.DafnySequence<? extends Character> _4_resourceType = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_2_info).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))));
      dafny.DafnySequence<? extends Character> _5_value = StandardLibrary_Compile.__default.<Character>Join(dafny.TypeDescriptor.CHAR, (_2_info).drop(java.math.BigInteger.ONE), dafny.DafnySequence.asString("/"));
      AwsResource _6_resource = AwsArnParsing_Compile.AwsResource.create(_4_resourceType, _5_value);
      Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _7_valueOrError1 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), __default.ValidAwsKmsResource(_6_resource), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed resource: "), identifier));
      if ((_7_valueOrError1).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_7_valueOrError1).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsResource._typeDescriptor());
      } else {
        return Wrappers_Compile.Result.<AwsResource, dafny.DafnySequence<? extends Character>>create_Success(_6_resource);
      }
    }
  }
  public static boolean ValidAmazonDynamodbResource(AwsResource resource) {
    return ((resource).Valid()) && (((resource).dtor_resourceType()).equals(dafny.DafnySequence.asString("table")));
  }
  public static boolean ValidAmazonDynamodbArn(AwsArn arn) {
    return (((arn).Valid()) && (((arn).dtor_service()).equals(dafny.DafnySequence.asString("dynamodb")))) && (__default.ValidAmazonDynamodbResource((arn).dtor_resource()));
  }
  public static Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> ParseAmazonDynamodbResources(dafny.DafnySequence<? extends Character> identifier) {
    Wrappers_Compile.Option<dafny.Tuple2<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>>> _8_info = StandardLibrary_Compile.__default.<Character>SplitOnce_q(dafny.TypeDescriptor.CHAR, identifier, '/');
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _9_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), (_8_info).is_Some(), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed resource: "), identifier));
    if ((_9_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_9_valueOrError0).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsResource._typeDescriptor());
    } else {
      dafny.DafnySequence<? extends Character> _10_resourceType = ((_8_info).dtor_value()).dtor__0();
      dafny.DafnySequence<? extends Character> _11_value = ((_8_info).dtor_value()).dtor__1();
      Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _12_valueOrError1 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(_11_value), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Table Name invalid: "), identifier));
      if ((_12_valueOrError1).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_12_valueOrError1).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsResource._typeDescriptor());
      } else {
        AwsResource _13_resource = AwsArnParsing_Compile.AwsResource.create(_10_resourceType, _11_value);
        Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _14_valueOrError2 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), __default.ValidAmazonDynamodbResource(_13_resource), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed resource: "), identifier));
        if ((_14_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
          return (_14_valueOrError2).<AwsResource>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        } else {
          return Wrappers_Compile.Result.<AwsResource, dafny.DafnySequence<? extends Character>>create_Success(_13_resource);
        }
      }
    }
  }
  public static Wrappers_Compile.Result<AwsArn, dafny.DafnySequence<? extends Character>> ParseAwsKmsArn(dafny.DafnySequence<? extends Character> identifier) {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _15_components = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, identifier, ':');
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _16_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), java.util.Objects.equals(java.math.BigInteger.valueOf(6L), java.math.BigInteger.valueOf((_15_components).length())), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed arn: "), identifier));
    if ((_16_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_16_valueOrError0).<AwsArn>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
    } else {
      Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> _17_valueOrError1 = __default.ParseAwsKmsResources(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(5L)))))));
      if ((_17_valueOrError1).IsFailure(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_17_valueOrError1).<AwsArn>PropagateFailure(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
      } else {
        AwsResource _18_resource = (_17_valueOrError1).Extract(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        AwsArn _19_arn = AwsArnParsing_Compile.AwsArn.create(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.ONE))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(3L)))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_15_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(4L)))))), _18_resource);
        Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _20_valueOrError2 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), __default.ValidAwsKmsArn(_19_arn), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed Arn:"), identifier));
        if ((_20_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
          return (_20_valueOrError2).<AwsArn>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        } else {
          return Wrappers_Compile.Result.<AwsArn, dafny.DafnySequence<? extends Character>>create_Success(_19_arn);
        }
      }
    }
  }
  public static Wrappers_Compile.Result<AwsArn, dafny.DafnySequence<? extends Character>> ParseAmazonDynamodbTableArn(dafny.DafnySequence<? extends Character> identifier) {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _21_components = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, identifier, ':');
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _22_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), java.util.Objects.equals(java.math.BigInteger.valueOf(6L), java.math.BigInteger.valueOf((_21_components).length())), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed arn: "), identifier));
    if ((_22_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_22_valueOrError0).<AwsArn>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
    } else {
      Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> _23_valueOrError1 = __default.ParseAmazonDynamodbResources(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(5L)))))));
      if ((_23_valueOrError1).IsFailure(AmazonDynamodbResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_23_valueOrError1).<AwsArn>PropagateFailure(AmazonDynamodbResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
      } else {
        AwsResource _24_resource = (_23_valueOrError1).Extract(AmazonDynamodbResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        AwsArn _25_arn = AwsArnParsing_Compile.AwsArn.create(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.ONE))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(3L)))))), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_21_components).select(dafny.Helpers.toInt((java.math.BigInteger.valueOf(4L)))))), _24_resource);
        Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _26_valueOrError2 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), __default.ValidAmazonDynamodbArn(_25_arn), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Malformed Arn:"), identifier));
        if ((_26_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
          return (_26_valueOrError2).<AwsArn>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        } else {
          return Wrappers_Compile.Result.<AwsArn, dafny.DafnySequence<? extends Character>>create_Success(_25_arn);
        }
      }
    }
  }
  public static Wrappers_Compile.Result<AwsKmsIdentifier, dafny.DafnySequence<? extends Character>> ParseAwsKmsIdentifier(dafny.DafnySequence<? extends Character> identifier) {
    if ((dafny.DafnySequence.asString("arn:")).isPrefixOf(identifier)) {
      Wrappers_Compile.Result<AwsArn, dafny.DafnySequence<? extends Character>> _27_valueOrError0 = __default.ParseAwsKmsArn(identifier);
      if ((_27_valueOrError0).IsFailure(AwsKmsArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_27_valueOrError0).<AwsKmsIdentifier>PropagateFailure(AwsKmsArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
      } else {
        AwsArn _28_arn = (_27_valueOrError0).Extract(AwsKmsArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        return Wrappers_Compile.Result.<AwsKmsIdentifier, dafny.DafnySequence<? extends Character>>create_Success(AwsArnParsing_Compile.AwsKmsIdentifier.create_AwsKmsArnIdentifier(_28_arn));
      }
    } else {
      Wrappers_Compile.Result<AwsResource, dafny.DafnySequence<? extends Character>> _29_valueOrError1 = __default.ParseAwsKmsRawResources(identifier);
      if ((_29_valueOrError1).IsFailure(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_29_valueOrError1).<AwsKmsIdentifier>PropagateFailure(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
      } else {
        AwsResource _30_r = (_29_valueOrError1).Extract(AwsKmsResource._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        return Wrappers_Compile.Result.<AwsKmsIdentifier, dafny.DafnySequence<? extends Character>>create_Success(AwsArnParsing_Compile.AwsKmsIdentifier.create_AwsKmsRawResourceIdentifier(_30_r));
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>> ParseAmazonDynamodbTableName(dafny.DafnySequence<? extends Character> identifier) {
    Wrappers_Compile.Result<AwsArn, dafny.DafnySequence<? extends Character>> _31_valueOrError0 = __default.ParseAmazonDynamodbTableArn(identifier);
    if ((_31_valueOrError0).IsFailure(AmazonDynamodbTableArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_31_valueOrError0).<dafny.DafnySequence<? extends Character>>PropagateFailure(AmazonDynamodbTableArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
    } else {
      AwsArn _32_arn = (_31_valueOrError0).Extract(AmazonDynamodbTableArn._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
      AmazonDynamodbTableName _33_tableArn = AwsArnParsing_Compile.AmazonDynamodbTableName.create(_32_arn);
      dafny.DafnySequence<? extends Character> _34_tableName = (_33_tableArn).GetTableName();
      return Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>>create_Success(_34_tableName);
    }
  }
  public static boolean IsMultiRegionAwsKmsArn(AwsArn arn) {
    return __default.IsMultiRegionAwsKmsResource((arn).dtor_resource());
  }
  public static boolean IsMultiRegionAwsKmsIdentifier(AwsKmsIdentifier identifier) {
    AwsKmsIdentifier _source0 = identifier;
    if (_source0.is_AwsKmsArnIdentifier()) {
      AwsArn _35___mcc_h0 = ((AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsArnIdentifier)_source0)._a;
      AwsArn _36_arn = _35___mcc_h0;
      return __default.IsMultiRegionAwsKmsArn(_36_arn);
    } else {
      AwsResource _37___mcc_h1 = ((AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source0)._r;
      AwsResource _38_r = _37___mcc_h1;
      return __default.IsMultiRegionAwsKmsResource(_38_r);
    }
  }
  public static boolean IsMultiRegionAwsKmsResource(AwsResource resource) {
    return (((resource).dtor_resourceType()).equals(dafny.DafnySequence.asString("key"))) && ((dafny.DafnySequence.asString("mrk-")).isPrefixOf((resource).dtor_value()));
  }
  public static Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> GetRegion(AwsKmsIdentifier identifier) {
    AwsKmsIdentifier _source1 = identifier;
    if (_source1.is_AwsKmsArnIdentifier()) {
      AwsArn _39___mcc_h0 = ((AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsArnIdentifier)_source1)._a;
      AwsArn _40_a = _39___mcc_h0;
      return Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_Some((_40_a).dtor_region());
    } else {
      AwsResource _41___mcc_h1 = ((AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source1)._r;
      return Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_None();
    }
  }
  public static Wrappers_Compile.Result<AwsKmsIdentifier, dafny.DafnySequence<? extends Character>> IsAwsKmsIdentifierString(dafny.DafnySequence<? extends Character> s) {
    Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _42_valueOrError0 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), UTF8.__default.IsASCIIString(s), dafny.DafnySequence.asString("Not a valid ASCII string."));
    if ((_42_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
      return (_42_valueOrError0).<AwsKmsIdentifier>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
    } else {
      Wrappers_Compile.Outcome<dafny.DafnySequence<? extends Character>> _43_valueOrError1 = Wrappers_Compile.__default.<dafny.DafnySequence<? extends Character>>Need(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), ((java.math.BigInteger.valueOf((s).length())).signum() == 1) && ((java.math.BigInteger.valueOf((s).length())).compareTo(__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0), dafny.DafnySequence.asString("Identifier exceeds maximum length."));
      if ((_43_valueOrError1).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR))) {
        return (_43_valueOrError1).<AwsKmsIdentifier>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
      } else {
        return __default.ParseAwsKmsIdentifier(s);
      }
    }
  }
  public static software.amazon.cryptography.materialproviders.internaldafny.types.Error Error(dafny.DafnySequence<? extends Character> s) {
    return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(s);
  }
  public static Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ValidateDdbTableArn(dafny.DafnySequence<? extends Character> tableArn) {
    Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _44_valueOrError0 = (__default.ParseAmazonDynamodbTableName(tableArn)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), __default::Error);
    if ((_44_valueOrError0).IsFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      return (_44_valueOrError0).<dafny.Tuple0>PropagateFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
    } else {
      dafny.DafnySequence<? extends Character> _45___v1 = (_44_valueOrError0).Extract(software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _46_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(tableArn), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Table Arn is not ASCII")));
      if ((_46_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        return (_46_valueOrError1).<dafny.Tuple0>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _47_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName((__default.ParseAmazonDynamodbTableName(tableArn)).dtor_value()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Table Name is too long")));
        if ((_47_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          return (_47_valueOrError2).<dafny.Tuple0>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
        } else {
          return Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
        }
      }
    }
  }
  public static java.math.BigInteger MAX__AWS__KMS__IDENTIFIER__LENGTH()
  {
    return java.math.BigInteger.valueOf(2048L);
  }
  @Override
  public java.lang.String toString() {
    return "AwsArnParsing._default";
  }
}
