// Class DecryptSingleEncryptedDataKey
// Dafny class DecryptSingleEncryptedDataKey compiled into Java
package AwsKmsHierarchicalKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class DecryptSingleEncryptedDataKey implements Actions_Compile.ActionWithResult<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>, Actions_Compile.Action<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
  public DecryptSingleEncryptedDataKey() {
    this._materials = (software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials)null;
    this._keyStore = null;
    this._cryptoPrimitives = null;
    this._branchKeyId = dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR);
    this._ttlSeconds = 0L;
    this._cache = null;
  }
  public void __ctor(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials materials, software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient keyStore, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives, dafny.DafnySequence<? extends Character> branchKeyId, long ttlSeconds, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache cache)
  {
    (this)._materials = materials;
    (this)._keyStore = keyStore;
    (this)._cryptoPrimitives = cryptoPrimitives;
    (this)._branchKeyId = branchKeyId;
    (this)._ttlSeconds = ttlSeconds;
    (this)._cache = cache;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey edk)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _894_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _894_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq((edk).dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Received invalid EDK provider info for Hierarchical Keyring")));
    if ((_894_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_894_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _895_suite;
    _895_suite = ((this).materials()).dtor_algorithmSuite();
    dafny.DafnySequence<? extends java.lang.Byte> _896_keyProviderId;
    _896_keyProviderId = (edk).dtor_keyProviderId();
    dafny.DafnySequence<? extends java.lang.Byte> _897_branchKeyIdUtf8;
    _897_branchKeyIdUtf8 = (edk).dtor_keyProviderInfo();
    dafny.DafnySequence<? extends java.lang.Byte> _898_ciphertext;
    _898_ciphertext = (edk).dtor_ciphertext();
    dafny.DafnySequence<? extends java.lang.Byte> _899_providerWrappedMaterial;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _900_valueOrError1 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _900_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_898_ciphertext, _895_suite);
    if ((_900_valueOrError1).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_900_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _899_providerWrappedMaterial = (_900_valueOrError1).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _901_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _901_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf((_899_providerWrappedMaterial).length())).compareTo(java.math.BigInteger.valueOf((__default.EDK__CIPHERTEXT__VERSION__INDEX()))) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Received EDK Ciphertext of incorrect length.")));
    if ((_901_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_901_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    dafny.DafnySequence<? extends java.lang.Byte> _902_branchKeyVersionUuid;
    _902_branchKeyVersionUuid = (_899_providerWrappedMaterial).subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
    dafny.DafnySequence<? extends Character> _903_version;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _904_valueOrError3 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR));
    _904_valueOrError3 = (UUID.__default.FromByteArray(_902_branchKeyVersionUuid)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
    if ((_904_valueOrError3).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_904_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _903_version = (_904_valueOrError3).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    dafny.DafnySequence<? extends java.lang.Byte> _905_cacheId;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _906_valueOrError4 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out164;
    _out164 = (this).GetVersionCacheId(_897_branchKeyIdUtf8, _903_version, (this).cryptoPrimitives());
    _906_valueOrError4 = _out164;
    if ((_906_valueOrError4).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_906_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _905_cacheId = (_906_valueOrError4).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials _907_hierarchicalMaterials;
    Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _908_valueOrError5 = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials.Default());
    Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out165;
    _out165 = (this).GetHierarchicalMaterialsVersion((this).branchKeyId(), _897_branchKeyIdUtf8, _903_version, _905_cacheId);
    _908_valueOrError5 = _out165;
    if ((_908_valueOrError5).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_908_valueOrError5).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _907_hierarchicalMaterials = (_908_valueOrError5).Extract(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    dafny.DafnySequence<? extends java.lang.Byte> _909_branchKey;
    _909_branchKey = (_907_hierarchicalMaterials).dtor_branchKey();
    dafny.DafnySequence<? extends java.lang.Byte> _910_branchKeyVersion;
    _910_branchKeyVersion = (_907_hierarchicalMaterials).dtor_branchKeyVersion();
    dafny.DafnySequence<? extends Character> _911_branchKeyVersionAsString;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _912_valueOrError6 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR));
    _912_valueOrError6 = (UTF8.__default.Decode(_910_branchKeyVersion)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
    if ((_912_valueOrError6).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_912_valueOrError6).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _911_branchKeyVersionAsString = (_912_valueOrError6).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    dafny.DafnySequence<? extends java.lang.Byte> _913_branchKeyVersionAsBytes;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _914_valueOrError7 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _914_valueOrError7 = (UUID.__default.ToByteArray(_911_branchKeyVersionAsString)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
    if ((_914_valueOrError7).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_914_valueOrError7).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _913_branchKeyVersionAsBytes = (_914_valueOrError7).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient, software.amazon.cryptography.primitives.internaldafny.types.Error> _915_maybeCrypto;
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient, software.amazon.cryptography.primitives.internaldafny.types.Error> _out166;
    _out166 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
    _915_maybeCrypto = _out166;
    software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _916_crypto;
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _917_valueOrError8 = (Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    _917_valueOrError8 = (_915_maybeCrypto).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_918_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _918_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_918_e_boxed0));
      return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_918_e);
    }));
    if ((_917_valueOrError8).IsFailure(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_917_valueOrError8).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _916_crypto = (_917_valueOrError8).Extract(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    KmsHierarchyUnwrapKeyMaterial _919_kmsHierarchyUnwrap;
    KmsHierarchyUnwrapKeyMaterial _nw37 = new KmsHierarchyUnwrapKeyMaterial();
    _nw37.__ctor(_909_branchKey, _897_branchKeyIdUtf8, _913_branchKeyVersionAsBytes, _916_crypto);
    _919_kmsHierarchyUnwrap = _nw37;
    Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _920_unwrapOutputRes;
    Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out167;
    _out167 = EdkWrapping_Compile.__default.<HierarchyUnwrapInfo>UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), (edk).dtor_ciphertext(), (this).materials(), _919_kmsHierarchyUnwrap);
    _920_unwrapOutputRes = _out167;
    EdkWrapping_Compile.UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _921_unwrapOutput;
    Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _922_valueOrError9 = Wrappers_Compile.Result.<EdkWrapping_Compile.UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(EdkWrapping_Compile.UnwrapEdkMaterialOutput.<HierarchyUnwrapInfo>Default(HierarchyUnwrapInfo.Default()));
    _922_valueOrError9 = _920_unwrapOutputRes;
    if ((_922_valueOrError9).IsFailure(EdkWrapping_Compile.UnwrapEdkMaterialOutput.<HierarchyUnwrapInfo>_typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_922_valueOrError9).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(EdkWrapping_Compile.UnwrapEdkMaterialOutput.<HierarchyUnwrapInfo>_typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _921_unwrapOutput = (_922_valueOrError9).Extract(EdkWrapping_Compile.UnwrapEdkMaterialOutput.<HierarchyUnwrapInfo>_typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _923_result;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _924_valueOrError10 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    _924_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey((this).materials(), (_921_unwrapOutput).dtor_plaintextDataKey(), (_921_unwrapOutput).dtor_symmetricSigningKey());
    if ((_924_valueOrError10).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_924_valueOrError10).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.SealedDecryptionMaterials._typeDescriptor());
      return res;
    }
    _923_result = (_924_valueOrError10).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_923_result);
    return res;
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(dafny.DafnySequence<? extends java.lang.Byte> branchKeyIdUtf8, dafny.DafnySequence<? extends Character> branchKeyVersion, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives)
  {
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _925_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _925_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((UTF8.__default.Decode(branchKeyIdUtf8)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError)).is_Success()) && (((boolean)(java.lang.Object)(dafny.Helpers.<dafny.DafnySequence<? extends Character>, Boolean>Let(((UTF8.__default.Decode(branchKeyIdUtf8)).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError)).dtor_value(), boxed40 -> {
      dafny.DafnySequence<? extends Character> _pat_let20_0 = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(boxed40));
      return ((boolean)(java.lang.Object)(dafny.Helpers.<dafny.DafnySequence<? extends Character>, Boolean>Let(_pat_let20_0, boxed41 -> {
        dafny.DafnySequence<? extends Character> _926_branchKeyId = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(boxed41));
        return (true) && (((java.math.BigInteger.valueOf((_926_branchKeyId).length())).signum() != -1) && ((java.math.BigInteger.valueOf((_926_branchKeyId).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0));
      }
      )));
    }
    )))), __default.E(dafny.DafnySequence.asString("Invalid Branch Key ID Length")));
    if ((_925_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      cacheId = (_925_valueOrError0).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()));
      return cacheId;
    }
    dafny.DafnySequence<? extends Character> _927_branchKeyId;
    _927_branchKeyId = (UTF8.__default.Decode(branchKeyIdUtf8)).dtor_value();
    dafny.DafnySequence<? extends java.lang.Byte> _928_lenBranchKey;
    _928_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq((_927_branchKeyId).cardinalityInt());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _929_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _929_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E(dafny.DafnySequence.asString("Unable to represent as an ASCII string.")));
    if ((_929_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      cacheId = (_929_valueOrError1).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()));
      return cacheId;
    }
    dafny.DafnySequence<? extends java.lang.Byte> _930_versionBytes;
    _930_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
    dafny.DafnySequence<? extends java.lang.Byte> _931_identifier;
    _931_identifier = dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(_928_lenBranchKey, branchKeyIdUtf8), dafny.DafnySequence.of((byte) 0)), _930_versionBytes);
    software.amazon.cryptography.primitives.internaldafny.types.DigestInput _932_identifierDigestInput;
    _932_identifierDigestInput = software.amazon.cryptography.primitives.internaldafny.types.DigestInput.create(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512(), _931_identifier);
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _933_maybeCacheDigest;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _out168;
    _out168 = Digest_Compile.__default.Digest(_932_identifierDigestInput);
    _933_maybeCacheDigest = _out168;
    dafny.DafnySequence<? extends java.lang.Byte> _934_cacheDigest;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _935_valueOrError2 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _935_valueOrError2 = (_933_maybeCacheDigest).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_936_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _936_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_936_e_boxed0));
      return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_936_e);
    }));
    if ((_935_valueOrError2).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      cacheId = (_935_valueOrError2).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()));
      return cacheId;
    }
    _934_cacheDigest = (_935_valueOrError2).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    cacheId = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success((_934_cacheDigest).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(32L)))));
    return cacheId;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(dafny.DafnySequence<? extends Character> branchKeyId, dafny.DafnySequence<? extends java.lang.Byte> branchKeyIdUtf8, dafny.DafnySequence<? extends Character> version, dafny.DafnySequence<? extends java.lang.Byte> cacheId)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials.Default());
    if(true) {
      software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput _937_getCacheInput;
      _937_getCacheInput = software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput.create(cacheId, Wrappers_Compile.Option.<java.lang.Long>create_None());
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _938_getCacheOutput;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out169;
      _out169 = __default.getEntry((this).cache(), _937_getCacheInput);
      _938_getCacheOutput = _out169;
      if ((_938_getCacheOutput).is_Failure()) {
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _939_maybeGetBranchKeyVersionOutput;
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out170;
        _out170 = ((this).keyStore()).GetBranchKeyVersion(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput.create(branchKeyId, version));
        _939_maybeGetBranchKeyVersionOutput = _out170;
        software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput _940_getBranchKeyVersionOutput;
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _941_valueOrError0 = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput.Default());
        _941_valueOrError0 = (_939_maybeGetBranchKeyVersionOutput).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.keystore.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_942_e_boxed0) -> {
          software.amazon.cryptography.keystore.internaldafny.types.Error _942_e = ((software.amazon.cryptography.keystore.internaldafny.types.Error)(java.lang.Object)(_942_e_boxed0));
          return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_942_e);
        }));
        if ((_941_valueOrError0).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          material = (_941_valueOrError0).<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor());
          return material;
        }
        _940_getBranchKeyVersionOutput = (_941_valueOrError0).Extract(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials _943_branchKeyMaterials;
        _943_branchKeyMaterials = (_940_getBranchKeyVersionOutput).dtor_branchKeyMaterials();
        long _944_now;
        long _out171;
        _out171 = Time.__default.CurrentRelativeTime();
        _944_now = _out171;
        Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _945_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
        _945_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.math.BigInteger.valueOf((_944_now))).add(java.math.BigInteger.valueOf(((this).ttlSeconds())))).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("INT64 Overflow when putting cache entry.")));
        if ((_945_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          material = (_945_valueOrError1).<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor());
          return material;
        }
        software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput _946_putCacheEntryInput;
        _946_putCacheEntryInput = software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput.create(cacheId, software.amazon.cryptography.materialproviders.internaldafny.types.Materials.create_BranchKey(_943_branchKeyMaterials), _944_now, (long)  (((this).ttlSeconds()) + (_944_now)), Wrappers_Compile.Option.<java.lang.Integer>create_None(), Wrappers_Compile.Option.<java.lang.Integer>create_None());
        dafny.Tuple0 _947___v1;
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _948_valueOrError2 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out172;
        _out172 = __default.putEntry((this).cache(), _946_putCacheEntryInput);
        _948_valueOrError2 = _out172;
        if ((_948_valueOrError2).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          material = (_948_valueOrError2).<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor());
          return material;
        }
        _947___v1 = (_948_valueOrError2).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        material = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_943_branchKeyMaterials);
        return material;
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _949_valueOrError3 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
        _949_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((((_938_getCacheOutput).dtor_value()).dtor_materials()).is_BranchKey()) && (java.util.Objects.equals(((_938_getCacheOutput).dtor_value()).dtor_materials(), software.amazon.cryptography.materialproviders.internaldafny.types.Materials.create_BranchKey((((_938_getCacheOutput).dtor_value()).dtor_materials()).dtor_BranchKey()))), __default.E(dafny.DafnySequence.asString("Invalid Material Type.")));
        if ((_949_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          material = (_949_valueOrError3).<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials._typeDescriptor());
          return material;
        }
        material = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success((((_938_getCacheOutput).dtor_value()).dtor_materials()).dtor_BranchKey());
        return material;
      }
    }
    return material;
  }
  public software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _materials;
  public software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials materials()
  {
    return this._materials;
  }
  public software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient _keyStore;
  public software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient keyStore()
  {
    return this._keyStore;
  }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _cryptoPrimitives;
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives()
  {
    return this._cryptoPrimitives;
  }
  public dafny.DafnySequence<? extends Character> _branchKeyId;
  public dafny.DafnySequence<? extends Character> branchKeyId()
  {
    return this._branchKeyId;
  }
  public long _ttlSeconds;
  public long ttlSeconds()
  {
    return this._ttlSeconds;
  }
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache _cache;
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache cache()
  {
    return this._cache;
  }
  private static final dafny.TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = dafny.TypeDescriptor.<DecryptSingleEncryptedDataKey>referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> (DecryptSingleEncryptedDataKey) null);
  public static dafny.TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
    return (dafny.TypeDescriptor<DecryptSingleEncryptedDataKey>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "AwsKmsHierarchicalKeyring.DecryptSingleEncryptedDataKey";
  }
}
