// Class KmsHierarchyWrapKeyMaterial
// Dafny class KmsHierarchyWrapKeyMaterial compiled into Java
package AwsKmsHierarchicalKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class KmsHierarchyWrapKeyMaterial implements MaterialWrapping_Compile.WrapMaterial<HierarchyWrapInfo>, Actions_Compile.ActionWithResult<MaterialWrapping_Compile.WrapInput, MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>, Actions_Compile.Action<MaterialWrapping_Compile.WrapInput, Wrappers_Compile.Result<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
  public KmsHierarchyWrapKeyMaterial() {
    this._branchKey = dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor());
    this._branchKeyIdUtf8 = UTF8.ValidUTF8Bytes.defaultValue();
    this._branchKeyVersionAsBytes = dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor());
    this._crypto = null;
  }
  public void __ctor(dafny.DafnySequence<? extends java.lang.Byte> branchKey, dafny.DafnySequence<? extends java.lang.Byte> branchKeyIdUtf8, dafny.DafnySequence<? extends java.lang.Byte> branchKeyVersionAsBytes, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient crypto)
  {
    (this)._branchKey = branchKey;
    (this)._branchKeyIdUtf8 = branchKeyIdUtf8;
    (this)._branchKeyVersionAsBytes = branchKeyVersionAsBytes;
    (this)._crypto = crypto;
  }
  public Wrappers_Compile.Result<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(MaterialWrapping_Compile.WrapInput input)
  {
    Wrappers_Compile.Result<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Wrappers_Compile.Result.<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>Default(HierarchyWrapInfo.Default()));
    software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _980_suite;
    _980_suite = (input).dtor_algorithmSuite();
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _981_maybeNonceSalt;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _out177;
    _out177 = ((this).crypto()).GenerateRandomBytes(software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput.create((int)  ((__default.H__WRAP__SALT__LEN()) + (__default.H__WRAP__NONCE__LEN()))));
    _981_maybeNonceSalt = _out177;
    dafny.DafnySequence<? extends java.lang.Byte> _982_saltAndNonce;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _983_valueOrError0 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _983_valueOrError0 = (_981_maybeNonceSalt).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_984_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _984_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_984_e_boxed0));
      return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_984_e);
    }));
    if ((_983_valueOrError0).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_983_valueOrError0).<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>_typeDescriptor(HierarchyWrapInfo._typeDescriptor()));
      return res;
    }
    _982_saltAndNonce = (_983_valueOrError0).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    dafny.DafnySequence<? extends java.lang.Byte> _985_salt;
    _985_salt = (_982_saltAndNonce).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), __default.H__WRAP__SALT__LEN());
    dafny.DafnySequence<? extends java.lang.Byte> _986_nonce;
    _986_nonce = (_982_saltAndNonce).drop(__default.H__WRAP__SALT__LEN());
    dafny.DafnySequence<? extends java.lang.Byte> _987_serializedEC;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _988_valueOrError1 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _988_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD((input).dtor_encryptionContext());
    if ((_988_valueOrError1).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_988_valueOrError1).<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>_typeDescriptor(HierarchyWrapInfo._typeDescriptor()));
      return res;
    }
    _987_serializedEC = (_988_valueOrError1).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    dafny.DafnySequence<? extends java.lang.Byte> _989_wrappingAad;
    _989_wrappingAad = __default.WrappingAad((this).branchKeyIdUtf8(), (this).branchKeyVersionAsBytes(), _987_serializedEC);
    dafny.DafnySequence<? extends java.lang.Byte> _990_derivedBranchKey;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _991_valueOrError2 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out178;
    _out178 = __default.DeriveEncryptionKeyFromBranchKey((this).branchKey(), _985_salt, Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_Some(Constants_Compile.__default.PROVIDER__ID__HIERARCHY()), (this).crypto());
    _991_valueOrError2 = _out178;
    if ((_991_valueOrError2).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_991_valueOrError2).<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>_typeDescriptor(HierarchyWrapInfo._typeDescriptor()));
      return res;
    }
    _990_derivedBranchKey = (_991_valueOrError2).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput, software.amazon.cryptography.primitives.internaldafny.types.Error> _992_maybeWrappedPdk;
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput, software.amazon.cryptography.primitives.internaldafny.types.Error> _out179;
    _out179 = ((this).crypto()).AESEncrypt(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput.create(__default.AES__256__ENC__ALG(), _986_nonce, _990_derivedBranchKey, (input).dtor_plaintextMaterial(), _989_wrappingAad));
    _992_maybeWrappedPdk = _out179;
    software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput _993_wrappedPdk;
    Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _994_valueOrError3 = Wrappers_Compile.Result.<software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput.Default());
    _994_valueOrError3 = (_992_maybeWrappedPdk).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput._typeDescriptor(), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_995_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _995_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_995_e_boxed0));
      return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_995_e);
    }));
    if ((_994_valueOrError3).IsFailure(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_994_valueOrError3).<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>>PropagateFailure(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>_typeDescriptor(HierarchyWrapInfo._typeDescriptor()));
      return res;
    }
    _993_wrappedPdk = (_994_valueOrError3).Extract(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo> _996_output;
    _996_output = MaterialWrapping_Compile.WrapOutput.<HierarchyWrapInfo>create(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(_985_salt, _986_nonce), (this).branchKeyVersionAsBytes()), (_993_wrappedPdk).dtor_cipherText()), (_993_wrappedPdk).dtor_authTag()), AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo.create());
    res = Wrappers_Compile.Result.<MaterialWrapping_Compile.WrapOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_996_output);
    return res;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _branchKey;
  public dafny.DafnySequence<? extends java.lang.Byte> branchKey()
  {
    return this._branchKey;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _branchKeyIdUtf8;
  public dafny.DafnySequence<? extends java.lang.Byte> branchKeyIdUtf8()
  {
    return this._branchKeyIdUtf8;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _branchKeyVersionAsBytes;
  public dafny.DafnySequence<? extends java.lang.Byte> branchKeyVersionAsBytes()
  {
    return this._branchKeyVersionAsBytes;
  }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _crypto;
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient crypto()
  {
    return this._crypto;
  }
  private static final dafny.TypeDescriptor<KmsHierarchyWrapKeyMaterial> _TYPE = dafny.TypeDescriptor.<KmsHierarchyWrapKeyMaterial>referenceWithInitializer(KmsHierarchyWrapKeyMaterial.class, () -> (KmsHierarchyWrapKeyMaterial) null);
  public static dafny.TypeDescriptor<KmsHierarchyWrapKeyMaterial> _typeDescriptor() {
    return (dafny.TypeDescriptor<KmsHierarchyWrapKeyMaterial>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "AwsKmsHierarchicalKeyring.KmsHierarchyWrapKeyMaterial";
  }
}
