// Class KmsGenerateAndWrapKeyMaterial
// Dafny class KmsGenerateAndWrapKeyMaterial compiled into Java
package AwsKmsKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class KmsGenerateAndWrapKeyMaterial implements MaterialWrapping_Compile.GenerateAndWrapMaterial<KmsWrapInfo>, Actions_Compile.ActionWithResult<MaterialWrapping_Compile.GenerateAndWrapInput, MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>, Actions_Compile.Action<MaterialWrapping_Compile.GenerateAndWrapInput, Wrappers_Compile.Result<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
  public KmsGenerateAndWrapKeyMaterial() {
    this._client = null;
    this._awsKmsKey = dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR);
    this._grantTokens = dafny.DafnySequence.<dafny.DafnySequence<? extends Character>> empty(software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType._typeDescriptor());
  }
  public void __ctor(software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient client, dafny.DafnySequence<? extends Character> awsKmsKey, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> grantTokens)
  {
    (this)._client = client;
    (this)._awsKmsKey = awsKmsKey;
    (this)._grantTokens = grantTokens;
  }
  public Wrappers_Compile.Result<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(MaterialWrapping_Compile.GenerateAndWrapInput input)
  {
    Wrappers_Compile.Result<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Wrappers_Compile.Result.<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>Default(KmsWrapInfo.Default()));
    software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _574_suite;
    _574_suite = (input).dtor_algorithmSuite();
    dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends Character>> _575_stringifiedEncCtx;
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _576_valueOrError0 = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends Character>> empty());
    _576_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext((input).dtor_encryptionContext());
    if ((_576_valueOrError0).IsFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_576_valueOrError0).<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>>PropagateFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>_typeDescriptor(KmsWrapInfo._typeDescriptor()));
      return res;
    }
    _575_stringifiedEncCtx = (_576_valueOrError0).Extract(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyRequest _577_generatorRequest;
    _577_generatorRequest = software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyRequest.create((this).awsKmsKey(), Wrappers_Compile.Option.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends Character>>>create_Some(_575_stringifiedEncCtx), Wrappers_Compile.Option.<java.lang.Integer>create_Some(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_574_suite)), Wrappers_Compile.Option.<software.amazon.cryptography.services.kms.internaldafny.types.DataKeySpec>create_None(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>create_Some((this).grantTokens()));
    Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _578_maybeGenerateResponse;
    Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out88;
    _out88 = ((this).client()).GenerateDataKey(_577_generatorRequest);
    _578_maybeGenerateResponse = _out88;
    software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse _579_generateResponse;
    Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _580_valueOrError1 = Wrappers_Compile.Result.<software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse.Default());
    _580_valueOrError1 = (_578_maybeGenerateResponse).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.services.kms.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_581_e_boxed0) -> {
      software.amazon.cryptography.services.kms.internaldafny.types.Error _581_e = ((software.amazon.cryptography.services.kms.internaldafny.types.Error)(java.lang.Object)(_581_e_boxed0));
      return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_ComAmazonawsKms(_581_e);
    }));
    if ((_580_valueOrError1).IsFailure(software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_580_valueOrError1).<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>>PropagateFailure(software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>_typeDescriptor(KmsWrapInfo._typeDescriptor()));
      return res;
    }
    _579_generateResponse = (_580_valueOrError1).Extract(software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _582_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _582_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((_579_generateResponse).dtor_KeyId()).is_Some()) && ((AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(((_579_generateResponse).dtor_KeyId()).dtor_value())).is_Success()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
    if ((_582_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_582_valueOrError2).<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>_typeDescriptor(KmsWrapInfo._typeDescriptor()));
      return res;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _583_valueOrError3 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _583_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((_579_generateResponse).dtor_Plaintext()).is_Some()) && (java.util.Objects.equals(java.math.BigInteger.valueOf((AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_574_suite))), java.math.BigInteger.valueOf((((_579_generateResponse).dtor_Plaintext()).dtor_value()).length()))), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Invalid response from AWS KMS GenerateDataKey: Invalid data key")));
    if ((_583_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_583_valueOrError3).<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>_typeDescriptor(KmsWrapInfo._typeDescriptor()));
      return res;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _584_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _584_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((_579_generateResponse).dtor_CiphertextBlob()).is_Some()) && (software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(((_579_generateResponse).dtor_CiphertextBlob()).dtor_value())), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Invalid response from AWS KMS GeneratedDataKey: Invalid ciphertext")));
    if ((_584_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_584_valueOrError4).<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>_typeDescriptor(KmsWrapInfo._typeDescriptor()));
      return res;
    }
    MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo> _585_output;
    _585_output = MaterialWrapping_Compile.GenerateAndWrapOutput.<KmsWrapInfo>create(((_579_generateResponse).dtor_Plaintext()).dtor_value(), ((_579_generateResponse).dtor_CiphertextBlob()).dtor_value(), AwsKmsKeyring_Compile.KmsWrapInfo.create(((_579_generateResponse).dtor_KeyId()).dtor_value()));
    res = Wrappers_Compile.Result.<MaterialWrapping_Compile.GenerateAndWrapOutput<KmsWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_585_output);
    return res;
  }
  public software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient _client;
  public software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient client()
  {
    return this._client;
  }
  public dafny.DafnySequence<? extends Character> _awsKmsKey;
  public dafny.DafnySequence<? extends Character> awsKmsKey()
  {
    return this._awsKmsKey;
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _grantTokens;
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> grantTokens()
  {
    return this._grantTokens;
  }
  private static final dafny.TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _TYPE = dafny.TypeDescriptor.<KmsGenerateAndWrapKeyMaterial>referenceWithInitializer(KmsGenerateAndWrapKeyMaterial.class, () -> (KmsGenerateAndWrapKeyMaterial) null);
  public static dafny.TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _typeDescriptor() {
    return (dafny.TypeDescriptor<KmsGenerateAndWrapKeyMaterial>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "AwsKmsKeyring.KmsGenerateAndWrapKeyMaterial";
  }
}
