// Class DefaultCMM
// Dafny class DefaultCMM compiled into Java
package DefaultCMM_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;
import AwsKmsHierarchicalKeyring_Compile.*;
import AwsKmsRsaKeyring_Compile.*;
import RawAESKeyring_Compile.*;
import RawRSAKeyring_Compile.*;
import CMM_Compile.*;
import Defaults_Compile.*;
import Commitment_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class DefaultCMM implements CMM_Compile.VerifiableInterface, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager {
  public DefaultCMM() {
    this._keyring = null;
    this._cryptoPrimitives = null;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetEncryptionMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out210;
    _out210 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsManager.GetEncryptionMaterials(this, input);
    return _out210;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecryptMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out211;
    _out211 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsManager.DecryptMaterials(this, input);
    return _out211;
  }
  public void OfKeyring(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring k, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient c)
  {
    (this)._keyring = k;
    (this)._cryptoPrimitives = c;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetEncryptionMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1175_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1175_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), !((input).dtor_encryptionContext()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(Materials_Compile.__default.EC__PUBLIC__KEY__FIELD()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Reserved Field found in EncryptionContext keys.")));
      if ((_1175_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1175_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId _1176_algorithmId;
      _1176_algorithmId = ((((input).dtor_algorithmSuiteId()).is_Some()) ? (((input).dtor_algorithmSuiteId()).dtor_value()) : (Defaults_Compile.__default.GetAlgorithmSuiteForCommitmentPolicy((input).dtor_commitmentPolicy())));
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1177_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1177_valueOrError1 = Commitment_Compile.__default.ValidateCommitmentPolicyOnEncrypt(_1176_algorithmId, (input).dtor_commitmentPolicy());
      if ((_1177_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1177_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _1178_suite;
      _1178_suite = AlgorithmSuites_Compile.__default.GetSuite(_1176_algorithmId);
      Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _1179_signingKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>Default();
      Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _1180_verificationKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>Default();
      if (((_1178_suite).dtor_signature()).is_ECDSA()) {
        Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput, software.amazon.cryptography.primitives.internaldafny.types.Error> _1181_maybeECDSAPair;
        Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput, software.amazon.cryptography.primitives.internaldafny.types.Error> _out212;
        _out212 = ((this).cryptoPrimitives()).GenerateECDSASignatureKey(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput.create((((_1178_suite).dtor_signature()).dtor_ECDSA()).dtor_curve()));
        _1181_maybeECDSAPair = _out212;
        software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput _1182_pair;
        Wrappers_Compile.Result<software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1183_valueOrError2 = Wrappers_Compile.Result.<software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput.Default());
        _1183_valueOrError2 = (_1181_maybeECDSAPair).<software.amazon.cryptography.materialproviders.internaldafny.types.Error>MapFailure(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput._typeDescriptor(), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)(_1184_e_boxed0) -> {
          software.amazon.cryptography.primitives.internaldafny.types.Error _1184_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_1184_e_boxed0));
          return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1184_e);
        }));
        if ((_1183_valueOrError2).IsFailure(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_1183_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
          return output;
        }
        _1182_pair = (_1183_valueOrError2).Extract(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _1179_signingKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_Some((_1182_pair).dtor_signingKey());
        _1180_verificationKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_Some((_1182_pair).dtor_verificationKey());
      } else {
        _1179_signingKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_None();
        _1180_verificationKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_None();
      }
      software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1185_materials;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1186_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
      _1186_valueOrError3 = Materials_Compile.__default.InitializeEncryptionMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput.create(_1176_algorithmId, (input).dtor_encryptionContext(), ((input).dtor_requiredEncryptionContextKeys()).UnwrapOr(dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(UTF8.ValidUTF8Bytes._typeDescriptor()), dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(UTF8.ValidUTF8Bytes._typeDescriptor())), _1179_signingKey, _1180_verificationKey));
      if ((_1186_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1186_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      _1185_materials = (_1186_valueOrError3).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput _1187_result;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1188_valueOrError4 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out213;
      _out213 = ((this).keyring()).OnEncrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput.create(_1185_materials));
      _1188_valueOrError4 = _out213;
      if ((_1188_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1188_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      _1187_result = (_1188_valueOrError4).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput _1189_encryptionMaterialsOutput;
      _1189_encryptionMaterialsOutput = software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput.create((_1187_result).dtor_materials());
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1190_valueOrError5 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1190_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.EncryptionMaterialsHasPlaintextDataKey((_1189_encryptionMaterialsOutput).dtor_encryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Could not retrieve materials required for encryption")));
      if ((_1190_valueOrError5).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1190_valueOrError5).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1191_valueOrError6 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1191_valueOrError6 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_1185_materials, (_1189_encryptionMaterialsOutput).dtor_encryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring returned an invalid response")));
      if ((_1191_valueOrError6).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1191_valueOrError6).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_1189_encryptionMaterialsOutput);
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecryptMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1192_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1192_valueOrError0 = Commitment_Compile.__default.ValidateCommitmentPolicyOnDecrypt((input).dtor_algorithmSuiteId(), (input).dtor_commitmentPolicy());
    if ((_1192_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1192_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _1193_requiredEncryptionContextKeys;
    _1193_requiredEncryptionContextKeys = dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(UTF8.ValidUTF8Bytes._typeDescriptor());
    if (((input).dtor_reproducedEncryptionContext()).is_Some()) {
      dafny.DafnySet<? extends dafny.DafnySequence<? extends java.lang.Byte>> _1194_keysSet;
      _1194_keysSet = (((input).dtor_reproducedEncryptionContext()).dtor_value()).keySet();
      while (!(_1194_keysSet).equals(dafny.DafnySet.<dafny.DafnySequence<? extends java.lang.Byte>> empty())) {
        dafny.DafnySequence<? extends java.lang.Byte> _1195_key;
        goto__ASSIGN_SUCH_THAT_0: {
          for (dafny.DafnySequence<? extends java.lang.Byte> _assign_such_that_0_boxed0 : (_1194_keysSet).Elements()) {
            dafny.DafnySequence<? extends java.lang.Byte> _assign_such_that_0 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_assign_such_that_0_boxed0));
            if (true) {
              _1195_key = (dafny.DafnySequence<? extends java.lang.Byte>)_assign_such_that_0;
              if ((_1194_keysSet).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1195_key)) {
                break goto__ASSIGN_SUCH_THAT_0;
              }
            }
          }
          throw new IllegalArgumentException("assign-such-that search produced no value (line 491)");
        }
        if (((input).dtor_encryptionContext()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1195_key)) {
          Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1196_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
          _1196_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((((input).dtor_reproducedEncryptionContext()).dtor_value()).get(_1195_key)))).equals(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(((input).dtor_encryptionContext()).get(_1195_key)))), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Encryption context does not match reproduced encryption context.")));
          if ((_1196_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_1196_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
            return output;
          }
        } else {
          _1193_requiredEncryptionContextKeys = dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>>concatenate(_1193_requiredEncryptionContextKeys, dafny.DafnySequence.of(UTF8.ValidUTF8Bytes._typeDescriptor(), _1195_key));
        }
        _1194_keysSet = dafny.DafnySet.<dafny.DafnySequence<? extends java.lang.Byte>>difference(_1194_keysSet, dafny.DafnySet.of(_1195_key));
      }
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _1197_materials;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1198_valueOrError2 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    _1198_valueOrError2 = Materials_Compile.__default.InitializeDecryptionMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput.create((input).dtor_algorithmSuiteId(), dafny.DafnyMap.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>>merge((input).dtor_encryptionContext(), ((input).dtor_reproducedEncryptionContext()).UnwrapOr(dafny.DafnyMap.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(UTF8.ValidUTF8Bytes._typeDescriptor(), UTF8.ValidUTF8Bytes._typeDescriptor()), dafny.DafnyMap.fromElements())), _1193_requiredEncryptionContextKeys));
    if ((_1198_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1198_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    _1197_materials = (_1198_valueOrError2).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput _1199_result;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1200_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out214;
    _out214 = ((this).keyring()).OnDecrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput.create(_1197_materials, (input).dtor_encryptedDataKeys()));
    _1200_valueOrError3 = _out214;
    if ((_1200_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1200_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    _1199_result = (_1200_valueOrError3).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1201_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1201_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsTransitionIsValid(_1197_materials, (_1199_result).dtor_materials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring.OnDecrypt failed to decrypt the plaintext data key.")));
    if ((_1201_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1201_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput.create((_1199_result).dtor_materials()));
    return output;
  }
  public software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring _keyring;
  public software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring keyring()
  {
    return this._keyring;
  }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _cryptoPrimitives;
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives()
  {
    return this._cryptoPrimitives;
  }
  private static final dafny.TypeDescriptor<DefaultCMM> _TYPE = dafny.TypeDescriptor.<DefaultCMM>referenceWithInitializer(DefaultCMM.class, () -> (DefaultCMM) null);
  public static dafny.TypeDescriptor<DefaultCMM> _typeDescriptor() {
    return (dafny.TypeDescriptor<DefaultCMM>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "DefaultCMM.DefaultCMM";
  }
}
