// Class LocalCMC
// Dafny class LocalCMC compiled into Java
package LocalCMC_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class LocalCMC implements software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache {
  public LocalCMC() {
    this.queue = null;
    this.cache = null;
    this._entryCapacity = java.math.BigInteger.ZERO;
    this._entryPruningTailSize = java.math.BigInteger.ZERO;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> PutCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out113;
    _out113 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache.PutCacheEntry(this, input);
    return _out113;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> UpdateUsageMetadata(software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out114;
    _out114 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache.UpdateUsageMetadata(this, input);
    return _out114;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out115;
    _out115 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache.GetCacheEntry(this, input);
    return _out115;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DeleteCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out116;
    _out116 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache.DeleteCacheEntry(this, input);
    return _out116;
  }
  public DoublyLinkedCacheEntryList queue;
  public DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, CacheEntry> cache;
  public void __ctor(java.math.BigInteger entryCapacity_k, java.math.BigInteger entryPruningTailSize_k)
  {
    (this)._entryCapacity = entryCapacity_k;
    (this)._entryPruningTailSize = entryPruningTailSize_k;
    DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, CacheEntry> _nw28 = new DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, CacheEntry>(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), CacheEntry._typeDescriptor());
    (this).cache = _nw28;
    DoublyLinkedCacheEntryList _nw29 = new DoublyLinkedCacheEntryList();
    _nw29.__ctor();
    (this).queue = _nw29;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      long _782_now;
      long _out117;
      _out117 = Time.__default.CurrentRelativeTime();
      _782_now = _out117;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out118;
      _out118 = (this).GetCacheEntryWithTime(input, _782_now);
      output = _out118;
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetCacheEntryWithTime(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input, long now)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      if ((this.cache).HasKey((input).dtor_identifier())) {
        CacheEntry _783_entry;
        _783_entry = (this.cache).Select((input).dtor_identifier());
        if ((now) <= ((_783_entry).expiryTime())) {
          (this.queue).moveToFront(_783_entry);
          output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput.create((_783_entry).materials(), (_783_entry).creationTime(), (_783_entry).expiryTime(), _783_entry.messagesUsed, _783_entry.bytesUsed));
          dafny.Tuple0 _784___v0;
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _785_valueOrError0 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out119;
          _out119 = (this).pruning(now);
          _785_valueOrError0 = _out119;
          if ((_785_valueOrError0).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_785_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput._typeDescriptor());
            return output;
          }
          _784___v0 = (_785_valueOrError0).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        } else {
          dafny.Tuple0 _786___v1;
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _787_valueOrError1 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out120;
          _out120 = (this).DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput.create((input).dtor_identifier()));
          _787_valueOrError1 = _out120;
          if ((_787_valueOrError1).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_787_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput._typeDescriptor());
            return output;
          }
          _786___v1 = (_787_valueOrError1).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
          output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_EntryDoesNotExist(dafny.DafnySequence.asString("Entry past TTL")));
        }
      } else {
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_EntryDoesNotExist(dafny.DafnySequence.asString("Entry does not exist")));
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> PutCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if(true) {
      if (((this).entryCapacity()).signum() == 0) {
        output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
        return output;
      }
      if ((this.cache).HasKey((input).dtor_identifier())) {
        dafny.Tuple0 _788___v2;
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _789_valueOrError0 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out121;
        _out121 = (this).DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput.create((input).dtor_identifier()));
        _789_valueOrError0 = _out121;
        if ((_789_valueOrError0).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_789_valueOrError0).<dafny.Tuple0>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
          return output;
        }
        _788___v2 = (_789_valueOrError0).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      }
      if (java.util.Objects.equals((this).entryCapacity(), (this.cache).Size())) {
        dafny.Tuple0 _790___v3;
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _791_valueOrError1 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out122;
        _out122 = (this).DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput.create(((this.queue.tail).dtor_deref()).identifier()));
        _791_valueOrError1 = _out122;
        if ((_791_valueOrError1).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_791_valueOrError1).<dafny.Tuple0>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
          return output;
        }
        _790___v3 = (_791_valueOrError1).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      }
      CacheEntry _792_cell;
      CacheEntry _nw30 = new CacheEntry();
      _nw30.__ctor((input).dtor_materials(), (input).dtor_identifier(), (input).dtor_creationTime(), (input).dtor_expiryTime(), ((input).dtor_messagesUsed()).UnwrapOr(software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger._typeDescriptor(), 0), ((input).dtor_bytesUsed()).UnwrapOr(software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger._typeDescriptor(), 0));
      _792_cell = _nw30;
      (this.queue).pushCell(_792_cell);
      (this.cache).Put((input).dtor_identifier(), _792_cell);
      output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if(true) {
      if ((this.cache).HasKey((input).dtor_identifier())) {
        CacheEntry _793_cell;
        _793_cell = (this.cache).Select((input).dtor_identifier());
        goto_1: {
          (this.cache).Remove((input).dtor_identifier());
        }
        (this.queue).remove(_793_cell);
      }
      output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> UpdateUsageMetadata_k(software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if ((this.cache).HasKey((input).dtor_identifier())) {
      CacheEntry _794_cell;
      _794_cell = (this.cache).Select((input).dtor_identifier());
      if (((_794_cell.messagesUsed) <= ((int)  ((__default.INT32__MAX__VALUE()) - (1)))) && ((_794_cell.bytesUsed) <= ((int)  ((__default.INT32__MAX__VALUE()) - ((input).dtor_bytesUsed()))))) {
        int _rhs0 = (int)  ((_794_cell.messagesUsed) + (1));
        int _rhs1 = (int)  ((_794_cell.bytesUsed) + ((input).dtor_bytesUsed()));
        CacheEntry _lhs0 = _794_cell;
        CacheEntry _lhs1 = _794_cell;
        _lhs0.messagesUsed = _rhs0;
        _lhs1.bytesUsed = _rhs1;
      } else {
        dafny.Tuple0 _795___v4;
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _796_valueOrError0 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out123;
        _out123 = (this).DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput.create((input).dtor_identifier()));
        _796_valueOrError0 = _out123;
        if ((_796_valueOrError0).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_796_valueOrError0).<dafny.Tuple0>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
          return output;
        }
        _795___v4 = (_796_valueOrError0).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      }
    }
    output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> pruning(long now)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    java.math.BigInteger _hi6 = (this).entryPruningTailSize();
    for (java.math.BigInteger _797_i = java.math.BigInteger.ZERO; _797_i.compareTo(_hi6) < 0; _797_i = _797_i.add(java.math.BigInteger.ONE)) {
      if ((this.queue.tail).is_Ptr()) {
        if ((((this.queue.tail).dtor_deref()).expiryTime()) < (now)) {
          dafny.Tuple0 _798___v5;
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _799_valueOrError0 = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
          Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out124;
          _out124 = (this).DeleteCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput.create(((this.queue.tail).dtor_deref()).identifier()));
          _799_valueOrError0 = _out124;
          if ((_799_valueOrError0).IsFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_799_valueOrError0).<dafny.Tuple0>PropagateFailure(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), dafny.Tuple0._typeDescriptor());
            return output;
          }
          _798___v5 = (_799_valueOrError0).Extract(dafny.Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        } else {
          output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
          return output;
        }
      } else {
        output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
        return output;
      }
    }
    output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(dafny.Tuple0.create());
    return output;
  }
  public java.math.BigInteger _entryCapacity;
  public java.math.BigInteger entryCapacity()
  {
    return this._entryCapacity;
  }
  public java.math.BigInteger _entryPruningTailSize;
  public java.math.BigInteger entryPruningTailSize()
  {
    return this._entryPruningTailSize;
  }
  private static final dafny.TypeDescriptor<LocalCMC> _TYPE = dafny.TypeDescriptor.<LocalCMC>referenceWithInitializer(LocalCMC.class, () -> (LocalCMC) null);
  public static dafny.TypeDescriptor<LocalCMC> _typeDescriptor() {
    return (dafny.TypeDescriptor<LocalCMC>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "LocalCMC.LocalCMC";
  }
}
