// Class MultiKeyring
// Dafny class MultiKeyring compiled into Java
package MultiKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class MultiKeyring implements Keyring_Compile.VerifiableInterface, software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring {
  public MultiKeyring() {
    this._generatorKeyring = Wrappers_Compile.Option.<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring>Default();
    this._childKeyrings = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> empty(software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring._typeDescriptor());
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out55;
    _out55 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnEncrypt(this, input);
    return _out55;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out56;
    _out56 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnDecrypt(this, input);
    return _out56;
  }
  public void __ctor(Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> generatorKeyring, dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> childKeyrings)
  {
    (this)._generatorKeyring = generatorKeyring;
    (this)._childKeyrings = childKeyrings;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if ((((this).generatorKeyring()).is_None()) && ((((input).dtor_materials()).dtor_plaintextDataKey()).is_None())) {
      dafny.DafnySequence<? extends Character> _377_exception;
      _377_exception = dafny.DafnySequence.asString("Need either a generator keyring or input encryption materials which contain a plaintext data key");
      res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(_377_exception));
      return res;
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _378_returnMaterials;
    _378_returnMaterials = (input).dtor_materials();
    if (((this).generatorKeyring()).is_Some()) {
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _379_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _379_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((input).dtor_materials()).dtor_plaintextDataKey()).is_None(), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("This multi keyring has a generator but provided Encryption Materials already contain plaintext data key")));
      if ((_379_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        res = (_379_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return res;
      }
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _380_onEncryptOutput;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out57;
      _out57 = (((this).generatorKeyring()).dtor_value()).OnEncrypt(input);
      _380_onEncryptOutput = _out57;
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _381_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _381_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_380_onEncryptOutput).is_Success(), (((_380_onEncryptOutput).is_Failure()) ? ((_380_onEncryptOutput).dtor_error()) : (software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Unexpected failure. Input to Need is !Success.")))));
      if ((_381_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        res = (_381_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return res;
      }
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _382_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _382_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition((input).dtor_materials(), ((_380_onEncryptOutput).dtor_value()).dtor_materials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Generator keyring returned invalid encryption materials")));
      if ((_382_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        res = (_382_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return res;
      }
      _378_returnMaterials = ((_380_onEncryptOutput).dtor_value()).dtor_materials();
    }
    java.math.BigInteger _hi0 = java.math.BigInteger.valueOf(((this).childKeyrings()).length());
    for (java.math.BigInteger _383_i = java.math.BigInteger.ZERO; _383_i.compareTo(_hi0) < 0; _383_i = _383_i.add(java.math.BigInteger.ONE)) {
      software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput _384_onEncryptInput;
      _384_onEncryptInput = software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput.create(_378_returnMaterials);
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _385_onEncryptOutput;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out58;
      _out58 = (((software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring)(java.lang.Object)(((this).childKeyrings()).select(dafny.Helpers.toInt((_383_i)))))).OnEncrypt(_384_onEncryptInput);
      _385_onEncryptOutput = _out58;
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _386_valueOrError3 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _386_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_385_onEncryptOutput).is_Success(), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Child keyring failed to encrypt plaintext data key")));
      if ((_386_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        res = (_386_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return res;
      }
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _387_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _387_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_378_returnMaterials, ((_385_onEncryptOutput).dtor_value()).dtor_materials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Child keyring performed invalid transition on encryption materials")));
      if ((_387_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        res = (_387_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return res;
      }
      _378_returnMaterials = ((_385_onEncryptOutput).dtor_value()).dtor_materials();
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _388_valueOrError5 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _388_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition((input).dtor_materials(), _378_returnMaterials), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("A child or generator keyring modified the encryption materials in illegal ways.")));
    if ((_388_valueOrError5).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_388_valueOrError5).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
      return res;
    }
    res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput.create(_378_returnMaterials));
    return res;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _389_materials;
    _389_materials = (input).dtor_materials();
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _390_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _390_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey((input).dtor_materials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring received decryption materials that already contain a plaintext data key.")));
    if ((_390_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      res = (_390_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return res;
    }
    dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error> _391_failures;
    _391_failures = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error> empty(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    if (((this).generatorKeyring()).is_Some()) {
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _392_result;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out59;
      _out59 = __default.AttemptDecryptDataKey(((this).generatorKeyring()).dtor_value(), input);
      _392_result = _out59;
      if ((_392_result).is_Success()) {
        if (((((_392_result).dtor_value()).dtor_materials()).dtor_plaintextDataKey()).is_Some()) {
          res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success((_392_result).dtor_value());
          return res;
        }
      } else {
        _391_failures = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_391_failures, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_392_result).dtor_error()));
      }
    }
    java.math.BigInteger _hi1 = java.math.BigInteger.valueOf(((this).childKeyrings()).length());
    for (java.math.BigInteger _393_j = java.math.BigInteger.ZERO; _393_j.compareTo(_hi1) < 0; _393_j = _393_j.add(java.math.BigInteger.ONE)) {
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _394_result;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out60;
      _out60 = __default.AttemptDecryptDataKey(((software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring)(java.lang.Object)(((this).childKeyrings()).select(dafny.Helpers.toInt((_393_j))))), input);
      _394_result = _out60;
      if ((_394_result).is_Success()) {
        res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success((_394_result).dtor_value());
        return res;
      } else {
        _391_failures = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_391_failures, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_394_result).dtor_error()));
      }
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.Error _395_combinedResult;
    _395_combinedResult = software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors(_391_failures, dafny.DafnySequence.asString("No Configured Keyring was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
    res = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(_395_combinedResult);
    return res;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> _generatorKeyring;
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> generatorKeyring()
  {
    return this._generatorKeyring;
  }
  public dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> _childKeyrings;
  public dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> childKeyrings()
  {
    return this._childKeyrings;
  }
  private static final dafny.TypeDescriptor<MultiKeyring> _TYPE = dafny.TypeDescriptor.<MultiKeyring>referenceWithInitializer(MultiKeyring.class, () -> (MultiKeyring) null);
  public static dafny.TypeDescriptor<MultiKeyring> _typeDescriptor() {
    return (dafny.TypeDescriptor<MultiKeyring>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "MultiKeyring.MultiKeyring";
  }
}
