// Class RawAESKeyring
// Dafny class RawAESKeyring compiled into Java
package RawAESKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;
import AwsKmsHierarchicalKeyring_Compile.*;
import AwsKmsRsaKeyring_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class RawAESKeyring implements Keyring_Compile.VerifiableInterface, software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring {
  public RawAESKeyring() {
    this._cryptoPrimitives = null;
    this._wrappingKey = dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor());
    this._wrappingAlgorithm = (software.amazon.cryptography.primitives.internaldafny.types.AES__GCM)null;
    this._keyNamespace = UTF8.ValidUTF8Bytes.defaultValue();
    this._keyName = UTF8.ValidUTF8Bytes.defaultValue();
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out193;
    _out193 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnEncrypt(this, input);
    return _out193;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out194;
    _out194 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnDecrypt(this, input);
    return _out194;
  }
  public void __ctor(dafny.DafnySequence<? extends java.lang.Byte> namespace, dafny.DafnySequence<? extends java.lang.Byte> name, dafny.DafnySequence<? extends java.lang.Byte> key, software.amazon.cryptography.primitives.internaldafny.types.AES__GCM wrappingAlgorithm, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives)
  {
    (this)._keyNamespace = namespace;
    (this)._keyName = name;
    (this)._wrappingKey = key;
    (this)._wrappingAlgorithm = wrappingAlgorithm;
    (this)._cryptoPrimitives = cryptoPrimitives;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1062_materials;
      _1062_materials = (input).dtor_materials();
      software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _1063_suite;
      _1063_suite = (_1062_materials).dtor_algorithmSuite();
      AesWrapKeyMaterial _1064_wrap;
      AesWrapKeyMaterial _nw45 = new AesWrapKeyMaterial();
      _nw45.__ctor((this).wrappingKey(), (this).wrappingAlgorithm(), (this).cryptoPrimitives());
      _1064_wrap = _nw45;
      AesGenerateAndWrapKeyMaterial _1065_generateAndWrap;
      AesGenerateAndWrapKeyMaterial _nw46 = new AesGenerateAndWrapKeyMaterial();
      _nw46.__ctor(_1064_wrap);
      _1065_generateAndWrap = _nw46;
      EdkWrapping_Compile.WrapEdkMaterialOutput<AesWrapInfo> _1066_wrapOutput;
      Wrappers_Compile.Result<EdkWrapping_Compile.WrapEdkMaterialOutput<AesWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1067_valueOrError0 = Wrappers_Compile.Result.<EdkWrapping_Compile.WrapEdkMaterialOutput<AesWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(EdkWrapping_Compile.WrapEdkMaterialOutput.<AesWrapInfo>Default(AesWrapInfo.Default()));
      Wrappers_Compile.Result<EdkWrapping_Compile.WrapEdkMaterialOutput<AesWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out195;
      _out195 = EdkWrapping_Compile.__default.<AesWrapInfo>WrapEdkMaterial(AesWrapInfo._typeDescriptor(), _1062_materials, _1064_wrap, _1065_generateAndWrap);
      _1067_valueOrError0 = _out195;
      if ((_1067_valueOrError0).IsFailure(EdkWrapping_Compile.WrapEdkMaterialOutput.<AesWrapInfo>_typeDescriptor(AesWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1067_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(EdkWrapping_Compile.WrapEdkMaterialOutput.<AesWrapInfo>_typeDescriptor(AesWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return output;
      }
      _1066_wrapOutput = (_1067_valueOrError0).Extract(EdkWrapping_Compile.WrapEdkMaterialOutput.<AesWrapInfo>_typeDescriptor(AesWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>> _1068_symmetricSigningKeyList;
      _1068_symmetricSigningKeyList = ((((_1066_wrapOutput).dtor_symmetricSigningKey()).is_Some()) ? (Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_Some(dafny.DafnySequence.of(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), ((_1066_wrapOutput).dtor_symmetricSigningKey()).dtor_value()))) : (Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_None()));
      software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _1069_edk;
      _1069_edk = software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey.create((this).keyNamespace(), (this).SerializeProviderInfo(((_1066_wrapOutput).dtor_wrapInfo()).dtor_iv()), (_1066_wrapOutput).dtor_wrappedMaterial());
      if ((_1066_wrapOutput).is_GenerateAndWrapEdkMaterialOutput()) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1070_result;
        Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1071_valueOrError1 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
        _1071_valueOrError1 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1062_materials, (_1066_wrapOutput).dtor_plaintextDataKey(), dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), _1069_edk), _1068_symmetricSigningKeyList);
        if ((_1071_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_1071_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
          return output;
        }
        _1070_result = (_1071_valueOrError1).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput.create(_1070_result));
        return output;
      } else if ((_1066_wrapOutput).is_WrapOnlyEdkMaterialOutput()) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1072_result;
        Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1073_valueOrError2 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
        _1073_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1062_materials, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), _1069_edk), _1068_symmetricSigningKeyList);
        if ((_1073_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_1073_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
          return output;
        }
        _1072_result = (_1073_valueOrError2).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput.create(_1072_result));
        return output;
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _1074_materials;
    _1074_materials = (input).dtor_materials();
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1075_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1075_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1074_materials), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring received decryption materials that already contain a plaintext data key.")));
    if ((_1075_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1075_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return output;
    }
    dafny.DafnySequence<? extends java.lang.Byte> _1076_aad;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1077_valueOrError1 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _1077_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(((input).dtor_materials()).dtor_encryptionContext());
    if ((_1077_valueOrError1).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1077_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return output;
    }
    _1076_aad = (_1077_valueOrError1).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1078_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1078_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), java.util.Objects.equals(java.math.BigInteger.valueOf(((this).wrappingKey()).length()), java.math.BigInteger.valueOf((((this).wrappingAlgorithm()).dtor_keyLength()))), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("The wrapping key does not match the wrapping algorithm")));
    if ((_1078_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1078_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return output;
    }
    dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1079_errors;
    _1079_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error> empty(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    java.math.BigInteger _hi8 = java.math.BigInteger.valueOf(((input).dtor_encryptedDataKeys()).length());
    for (java.math.BigInteger _1080_i = java.math.BigInteger.ZERO; _1080_i.compareTo(_hi8) < 0; _1080_i = _1080_i.add(java.math.BigInteger.ONE)) {
      if ((this).ShouldDecryptEDK(((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)(((input).dtor_encryptedDataKeys()).select(dafny.Helpers.toInt((_1080_i))))))) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _1081_edk;
        _1081_edk = ((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)(((input).dtor_encryptedDataKeys()).select(dafny.Helpers.toInt((_1080_i)))));
        dafny.DafnySequence<? extends java.lang.Byte> _1082_iv;
        _1082_iv = (this).GetIvFromProvInfo((_1081_edk).dtor_keyProviderInfo());
        AesUnwrapKeyMaterial _1083_unwrap;
        AesUnwrapKeyMaterial _nw47 = new AesUnwrapKeyMaterial();
        _nw47.__ctor((this).wrappingKey(), (this).wrappingAlgorithm(), _1082_iv, (this).cryptoPrimitives());
        _1083_unwrap = _nw47;
        Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<AesUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1084_unwrapOutput;
        Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<AesUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out196;
        _out196 = EdkWrapping_Compile.__default.<AesUnwrapInfo>UnwrapEdkMaterial(AesUnwrapInfo._typeDescriptor(), (_1081_edk).dtor_ciphertext(), _1074_materials, _1083_unwrap);
        _1084_unwrapOutput = _out196;
        if ((_1084_unwrapOutput).is_Success()) {
          software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _1085_result;
          Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1086_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
          _1086_valueOrError3 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1074_materials, ((_1084_unwrapOutput).dtor_value()).dtor_plaintextDataKey(), ((_1084_unwrapOutput).dtor_value()).dtor_symmetricSigningKey());
          if ((_1086_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_1086_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
            return output;
          }
          _1085_result = (_1086_valueOrError3).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
          software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput _1087_value;
          _1087_value = software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput.create(_1085_result);
          output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_1087_value);
          return output;
        } else {
          _1079_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_1079_errors, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_1084_unwrapOutput).dtor_error()));
        }
      } else {
        _1079_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_1079_errors, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("EncrypedDataKey "), String_Compile.__default.Base10Int2String(_1080_i)), dafny.DafnySequence.asString(" did not match AESKeyring. ")))));
      }
    }
    output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors(_1079_errors, dafny.DafnySequence.asString("Raw AES Keyring was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
    return output;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> SerializeProviderInfo(dafny.DafnySequence<? extends java.lang.Byte> iv) {
    return dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate((this).keyName(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(((int)  ((((this).wrappingAlgorithm()).dtor_tagLength()) * (8))))), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq((((this).wrappingAlgorithm()).dtor_ivLength()))), iv);
  }
  public boolean ShouldDecryptEDK(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey edk) {
    return (((edk).dtor_keyProviderId()).equals((this).keyNamespace())) && ((this).ValidProviderInfo((edk).dtor_keyProviderInfo()));
  }
  public boolean ValidProviderInfo(dafny.DafnySequence<? extends java.lang.Byte> info) {
    return (((((java.util.Objects.equals(java.math.BigInteger.valueOf((info).length()), (((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())).add(__default.IV__LEN__LEN())).add(java.math.BigInteger.valueOf((((this).wrappingAlgorithm()).dtor_ivLength()))))) && (((info).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(((this).keyName()).length()))))).equals((this).keyName()))) && ((StandardLibrary_mUInt_Compile.__default.SeqToUInt32((info).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(((this).keyName()).length()))), dafny.Helpers.toInt(((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())))))) == (128))) && ((StandardLibrary_mUInt_Compile.__default.SeqToUInt32((info).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(((this).keyName()).length()))), dafny.Helpers.toInt(((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())))))) == ((int)  (((((this).wrappingAlgorithm()).dtor_tagLength())) * (8))))) && ((StandardLibrary_mUInt_Compile.__default.SeqToUInt32((info).subsequence(dafny.Helpers.toInt(((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN()))), dafny.Helpers.toInt((((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())).add(__default.IV__LEN__LEN())))))) == ((((this).wrappingAlgorithm()).dtor_ivLength())))) && ((StandardLibrary_mUInt_Compile.__default.SeqToUInt32((info).subsequence(dafny.Helpers.toInt(((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN()))), dafny.Helpers.toInt((((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())).add(__default.IV__LEN__LEN())))))) == (12));
  }
  public dafny.DafnySequence<? extends java.lang.Byte> GetIvFromProvInfo(dafny.DafnySequence<? extends java.lang.Byte> info) {
    return (info).drop(((java.math.BigInteger.valueOf(((this).keyName()).length())).add(__default.AUTH__TAG__LEN__LEN())).add(__default.IV__LEN__LEN()));
  }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _cryptoPrimitives;
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives()
  {
    return this._cryptoPrimitives;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _wrappingKey;
  public dafny.DafnySequence<? extends java.lang.Byte> wrappingKey()
  {
    return this._wrappingKey;
  }
  public software.amazon.cryptography.primitives.internaldafny.types.AES__GCM _wrappingAlgorithm;
  public software.amazon.cryptography.primitives.internaldafny.types.AES__GCM wrappingAlgorithm()
  {
    return this._wrappingAlgorithm;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _keyNamespace;
  public dafny.DafnySequence<? extends java.lang.Byte> keyNamespace()
  {
    return this._keyNamespace;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _keyName;
  public dafny.DafnySequence<? extends java.lang.Byte> keyName()
  {
    return this._keyName;
  }
  private static final dafny.TypeDescriptor<RawAESKeyring> _TYPE = dafny.TypeDescriptor.<RawAESKeyring>referenceWithInitializer(RawAESKeyring.class, () -> (RawAESKeyring) null);
  public static dafny.TypeDescriptor<RawAESKeyring> _typeDescriptor() {
    return (dafny.TypeDescriptor<RawAESKeyring>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "RawAESKeyring.RawAESKeyring";
  }
}
