// Class RawRSAKeyring
// Dafny class RawRSAKeyring compiled into Java
package RawRSAKeyring_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;
import AwsKmsHierarchicalKeyring_Compile.*;
import AwsKmsRsaKeyring_Compile.*;
import RawAESKeyring_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class RawRSAKeyring implements Keyring_Compile.VerifiableInterface, software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring {
  public RawRSAKeyring() {
    this._cryptoPrimitives = null;
    this._keyNamespace = UTF8.ValidUTF8Bytes.defaultValue();
    this._keyName = UTF8.ValidUTF8Bytes.defaultValue();
    this._paddingScheme = software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode.Default();
    this._publicKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>Default();
    this._privateKey = Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>Default();
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out202;
    _out202 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnEncrypt(this, input);
    return _out202;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out203;
    _out203 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring.OnDecrypt(this, input);
    return _out203;
  }
  public void __ctor(dafny.DafnySequence<? extends java.lang.Byte> namespace, dafny.DafnySequence<? extends java.lang.Byte> name, Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> publicKey, Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> privateKey, software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode paddingScheme, software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives)
  {
    (this)._keyNamespace = namespace;
    (this)._keyName = name;
    (this)._paddingScheme = paddingScheme;
    (this)._publicKey = publicKey;
    (this)._privateKey = privateKey;
    (this)._cryptoPrimitives = cryptoPrimitives;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1114_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1114_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((this).publicKey()).is_Some()) && ((java.math.BigInteger.valueOf((((this).publicKey()).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()))).length())).signum() == 1), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("A RawRSAKeyring without a public key cannot provide OnEncrypt")));
      if ((_1114_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1114_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return output;
      }
      software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1115_materials;
      _1115_materials = (input).dtor_materials();
      software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo _1116_suite;
      _1116_suite = (_1115_materials).dtor_algorithmSuite();
      RsaWrapKeyMaterial _1117_wrap;
      RsaWrapKeyMaterial _nw48 = new RsaWrapKeyMaterial();
      _nw48.__ctor(((this).publicKey()).dtor_value(), (this).paddingScheme(), (this).cryptoPrimitives());
      _1117_wrap = _nw48;
      RsaGenerateAndWrapKeyMaterial _1118_generateAndWrap;
      RsaGenerateAndWrapKeyMaterial _nw49 = new RsaGenerateAndWrapKeyMaterial();
      _nw49.__ctor(((this).publicKey()).dtor_value(), (this).paddingScheme(), (this).cryptoPrimitives());
      _1118_generateAndWrap = _nw49;
      EdkWrapping_Compile.WrapEdkMaterialOutput<RsaWrapInfo> _1119_wrapOutput;
      Wrappers_Compile.Result<EdkWrapping_Compile.WrapEdkMaterialOutput<RsaWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1120_valueOrError1 = Wrappers_Compile.Result.<EdkWrapping_Compile.WrapEdkMaterialOutput<RsaWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(EdkWrapping_Compile.WrapEdkMaterialOutput.<RsaWrapInfo>Default(RsaWrapInfo.Default()));
      Wrappers_Compile.Result<EdkWrapping_Compile.WrapEdkMaterialOutput<RsaWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out204;
      _out204 = EdkWrapping_Compile.__default.<RsaWrapInfo>WrapEdkMaterial(RsaWrapInfo._typeDescriptor(), _1115_materials, _1117_wrap, _1118_generateAndWrap);
      _1120_valueOrError1 = _out204;
      if ((_1120_valueOrError1).IsFailure(EdkWrapping_Compile.WrapEdkMaterialOutput.<RsaWrapInfo>_typeDescriptor(RsaWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1120_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(EdkWrapping_Compile.WrapEdkMaterialOutput.<RsaWrapInfo>_typeDescriptor(RsaWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
        return output;
      }
      _1119_wrapOutput = (_1120_valueOrError1).Extract(EdkWrapping_Compile.WrapEdkMaterialOutput.<RsaWrapInfo>_typeDescriptor(RsaWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>> _1121_symmetricSigningKeyList;
      _1121_symmetricSigningKeyList = ((((_1119_wrapOutput).dtor_symmetricSigningKey()).is_Some()) ? (Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_Some(dafny.DafnySequence.of(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), ((_1119_wrapOutput).dtor_symmetricSigningKey()).dtor_value()))) : (Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_None()));
      software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _1122_edk;
      _1122_edk = software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey.create((this).keyNamespace(), (this).keyName(), (_1119_wrapOutput).dtor_wrappedMaterial());
      if ((_1119_wrapOutput).is_GenerateAndWrapEdkMaterialOutput()) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1123_result;
        Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1124_valueOrError2 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
        _1124_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1115_materials, (_1119_wrapOutput).dtor_plaintextDataKey(), dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), _1122_edk), _1121_symmetricSigningKeyList);
        if ((_1124_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_1124_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
          return output;
        }
        _1123_result = (_1124_valueOrError2).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput.create(_1123_result));
        return output;
      } else if ((_1119_wrapOutput).is_WrapOnlyEdkMaterialOutput()) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials _1125_result;
        Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1126_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
        _1126_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1115_materials, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), _1122_edk), _1121_symmetricSigningKeyList);
        if ((_1126_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
          output = (_1126_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput._typeDescriptor());
          return output;
        }
        _1125_result = (_1126_valueOrError3).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput.create(_1125_result));
        return output;
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1127_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1127_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (((this).privateKey()).is_Some()) && ((java.math.BigInteger.valueOf((((this).privateKey()).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()))).length())).signum() == 1), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("A RawRSAKeyring without a private key cannot provide OnEncrypt")));
    if ((_1127_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1127_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return output;
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _1128_materials;
    _1128_materials = (input).dtor_materials();
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1129_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1129_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1128_materials), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring received decryption materials that already contain a plaintext data key.")));
    if ((_1129_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1129_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
      return output;
    }
    dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1130_errors;
    _1130_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error> empty(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    java.math.BigInteger _hi9 = java.math.BigInteger.valueOf(((input).dtor_encryptedDataKeys()).length());
    for (java.math.BigInteger _1131_i = java.math.BigInteger.ZERO; _1131_i.compareTo(_hi9) < 0; _1131_i = _1131_i.add(java.math.BigInteger.ONE)) {
      if ((this).ShouldDecryptEDK(((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)(((input).dtor_encryptedDataKeys()).select(dafny.Helpers.toInt((_1131_i))))))) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _1132_edk;
        _1132_edk = ((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)(((input).dtor_encryptedDataKeys()).select(dafny.Helpers.toInt((_1131_i)))));
        RsaUnwrapKeyMaterial _1133_unwrap;
        RsaUnwrapKeyMaterial _nw50 = new RsaUnwrapKeyMaterial();
        _nw50.__ctor(((this).privateKey()).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), (this).paddingScheme(), (this).cryptoPrimitives());
        _1133_unwrap = _nw50;
        Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<RsaUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1134_unwrapOutput;
        Wrappers_Compile.Result<EdkWrapping_Compile.UnwrapEdkMaterialOutput<RsaUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out205;
        _out205 = EdkWrapping_Compile.__default.<RsaUnwrapInfo>UnwrapEdkMaterial(RsaUnwrapInfo._typeDescriptor(), (_1132_edk).dtor_ciphertext(), _1128_materials, _1133_unwrap);
        _1134_unwrapOutput = _out205;
        if ((_1134_unwrapOutput).is_Success()) {
          software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials _1135_returnMaterials;
          Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1136_valueOrError2 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
          _1136_valueOrError2 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1128_materials, ((_1134_unwrapOutput).dtor_value()).dtor_plaintextDataKey(), ((_1134_unwrapOutput).dtor_value()).dtor_symmetricSigningKey());
          if ((_1136_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            output = (_1136_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor());
            return output;
          }
          _1135_returnMaterials = (_1136_valueOrError2).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
          output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput.create(_1135_returnMaterials));
          return output;
        } else {
          _1130_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_1130_errors, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (_1134_unwrapOutput).dtor_error()));
        }
      } else {
        _1130_errors = dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>concatenate(_1130_errors, dafny.DafnySequence.of(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("EncryptedDataKey "), String_Compile.__default.Base10Int2String(_1131_i)), dafny.DafnySequence.asString(" did not match RSAKeyring. ")))));
      }
    }
    output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors(_1130_errors, dafny.DafnySequence.asString("Raw RSA Key was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
    return output;
  }
  public boolean ShouldDecryptEDK(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey edk) {
    return (((UTF8.__default.ValidUTF8Seq((edk).dtor_keyProviderInfo())) && (((edk).dtor_keyProviderInfo()).equals((this).keyName()))) && (((edk).dtor_keyProviderId()).equals((this).keyNamespace()))) && ((java.math.BigInteger.valueOf(((edk).dtor_ciphertext()).length())).signum() == 1);
  }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _cryptoPrimitives;
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient cryptoPrimitives()
  {
    return this._cryptoPrimitives;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _keyNamespace;
  public dafny.DafnySequence<? extends java.lang.Byte> keyNamespace()
  {
    return this._keyNamespace;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> _keyName;
  public dafny.DafnySequence<? extends java.lang.Byte> keyName()
  {
    return this._keyName;
  }
  public software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode _paddingScheme;
  public software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode paddingScheme()
  {
    return this._paddingScheme;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _publicKey;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> publicKey()
  {
    return this._publicKey;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _privateKey;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> privateKey()
  {
    return this._privateKey;
  }
  private static final dafny.TypeDescriptor<RawRSAKeyring> _TYPE = dafny.TypeDescriptor.<RawRSAKeyring>referenceWithInitializer(RawRSAKeyring.class, () -> (RawRSAKeyring) null);
  public static dafny.TypeDescriptor<RawRSAKeyring> _typeDescriptor() {
    return (dafny.TypeDescriptor<RawRSAKeyring>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "RawRSAKeyring.RawRSAKeyring";
  }
}
