// Class RequiredEncryptionContextCMM
// Dafny class RequiredEncryptionContextCMM compiled into Java
package RequiredEncryptionContextCMM_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;
import StormTracker_Compile.*;
import AwsKmsHierarchicalKeyring_Compile.*;
import AwsKmsRsaKeyring_Compile.*;
import RawAESKeyring_Compile.*;
import RawRSAKeyring_Compile.*;
import CMM_Compile.*;
import Defaults_Compile.*;
import Commitment_Compile.*;
import DefaultCMM_Compile.*;
import DefaultClientSupplier_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class RequiredEncryptionContextCMM implements CMM_Compile.VerifiableInterface, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager {
  public RequiredEncryptionContextCMM() {
    this._underlyingCMM = null;
    this._requiredEncryptionContextKeys = dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(UTF8.ValidUTF8Bytes._typeDescriptor());
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetEncryptionMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out217;
    _out217 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsManager.GetEncryptionMaterials(this, input);
    return _out217;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecryptMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out218;
    _out218 = software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsManager.DecryptMaterials(this, input);
    return _out218;
  }
  public void __ctor(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager inputCMM, dafny.DafnySet<? extends dafny.DafnySequence<? extends java.lang.Byte>> inputKeys)
  {
    dafny.DafnySet<? extends dafny.DafnySequence<? extends java.lang.Byte>> _1204_keySet;
    _1204_keySet = inputKeys;
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _1205_keySeq;
    _1205_keySeq = dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(UTF8.ValidUTF8Bytes._typeDescriptor());
    while (!(_1204_keySet).equals(dafny.DafnySet.<dafny.DafnySequence<? extends java.lang.Byte>> empty())) {
      dafny.DafnySequence<? extends java.lang.Byte> _1206_key;
      goto__ASSIGN_SUCH_THAT_1: {
        for (dafny.DafnySequence<? extends java.lang.Byte> _assign_such_that_1_boxed0 : (_1204_keySet).Elements()) {
          dafny.DafnySequence<? extends java.lang.Byte> _assign_such_that_1 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_assign_such_that_1_boxed0));
          if (true) {
            _1206_key = (dafny.DafnySequence<? extends java.lang.Byte>)_assign_such_that_1;
            if ((_1204_keySet).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1206_key)) {
              break goto__ASSIGN_SUCH_THAT_1;
            }
          }
        }
        throw new IllegalArgumentException("assign-such-that search produced no value (line 61)");
      }
      _1205_keySeq = dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>>concatenate(_1205_keySeq, dafny.DafnySequence.of(UTF8.ValidUTF8Bytes._typeDescriptor(), _1206_key));
      _1204_keySet = dafny.DafnySet.<dafny.DafnySequence<? extends java.lang.Byte>>difference(_1204_keySet, dafny.DafnySet.of(_1206_key));
    }
    (this)._underlyingCMM = inputCMM;
    (this)._requiredEncryptionContextKeys = _1205_keySeq;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetEncryptionMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1207_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1207_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput, Boolean>)(_1208_input) -> dafny.Helpers.Quantifier(((this).requiredEncryptionContextKeys()).UniqueElements(), true, ((_forall_var_15_boxed0) -> {
        dafny.DafnySequence<? extends java.lang.Byte> _forall_var_15 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_forall_var_15_boxed0));
        if (true) {
          dafny.DafnySequence<? extends java.lang.Byte> _1209_k = (dafny.DafnySequence<? extends java.lang.Byte>)_forall_var_15;
          return !(((this).requiredEncryptionContextKeys()).contains(_1209_k)) || (((_1208_input).dtor_encryptionContext()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1209_k));
        } else {
          return true;
        }
      }))).apply(input), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Encryption context does not contain required keys.")));
      if ((_1207_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1207_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput _1210_result;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1211_valueOrError1 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
      software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput _pat_let_tv32 = input;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out219;
      _out219 = ((this).underlyingCMM()).GetEncryptionMaterials(((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(dafny.Helpers.<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput, software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput>Let(input, boxed42 -> {
        software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput _pat_let21_0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(boxed42));
        return ((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(dafny.Helpers.<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput, software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput>Let(_pat_let21_0, boxed43 -> {
          software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput _1212_dt__update__tmp_h0 = ((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(boxed43));
          return ((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>, software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput>Let(Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_Some(dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>>concatenate(((_pat_let_tv32).dtor_requiredEncryptionContextKeys()).UnwrapOr(dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(UTF8.ValidUTF8Bytes._typeDescriptor()), dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(UTF8.ValidUTF8Bytes._typeDescriptor())), (this).requiredEncryptionContextKeys())), boxed44 -> {
            Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>> _pat_let22_0 = ((Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(java.lang.Object)(boxed44));
            return ((software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>, software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput>Let(_pat_let22_0, boxed45 -> {
              Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>> _1213_dt__update_hrequiredEncryptionContextKeys_h0 = ((Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(java.lang.Object)(boxed45));
              return software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput.create((_1212_dt__update__tmp_h0).dtor_encryptionContext(), (_1212_dt__update__tmp_h0).dtor_commitmentPolicy(), (_1212_dt__update__tmp_h0).dtor_algorithmSuiteId(), (_1212_dt__update__tmp_h0).dtor_maxPlaintextLength(), _1213_dt__update_hrequiredEncryptionContextKeys_h0);
            }
            )));
          }
          )));
        }
        )));
      }
      ))));
      _1211_valueOrError1 = _out219;
      if ((_1211_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1211_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      _1210_result = (_1211_valueOrError1).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1214_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1214_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, Boolean>)(_1215_result) -> dafny.Helpers.Quantifier(((this).requiredEncryptionContextKeys()).UniqueElements(), true, ((_forall_var_16_boxed0) -> {
        dafny.DafnySequence<? extends java.lang.Byte> _forall_var_16 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_forall_var_16_boxed0));
        if (true) {
          dafny.DafnySequence<? extends java.lang.Byte> _1216_k = (dafny.DafnySequence<? extends java.lang.Byte>)_forall_var_16;
          return !(((this).requiredEncryptionContextKeys()).contains(_1216_k)) || ((((_1215_result).dtor_encryptionMaterials()).dtor_requiredEncryptionContextKeys()).contains(_1216_k));
        } else {
          return true;
        }
      }))).apply(_1210_result), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Expected encryption context keys do not exist in keys to only authenticate.")));
      if ((_1214_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1214_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1217_valueOrError3 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1217_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.EncryptionMaterialsHasPlaintextDataKey((_1210_result).dtor_encryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Could not retrieve materials required for encryption")));
      if ((_1217_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1217_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1218_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
      _1218_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), CMM_Compile.__default.RequiredEncryptionContextKeys_q((input).dtor_requiredEncryptionContextKeys(), (_1210_result).dtor_encryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring returned an invalid response")));
      if ((_1218_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
        output = (_1218_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput._typeDescriptor());
        return output;
      }
      output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_1210_result);
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecryptMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1219_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1219_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((input).dtor_reproducedEncryptionContext()).is_Some(), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("No reproduced encryption context on decrypt.")));
    if ((_1219_valueOrError0).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1219_valueOrError0).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1220_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1220_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), CMM_Compile.__default.ReproducedEncryptionContext_q(input), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Encryption context does not match reproduced encryption context.")));
    if ((_1220_valueOrError1).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1220_valueOrError1).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1221_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1221_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput, Boolean>)(_1222_input) -> dafny.Helpers.Quantifier(((this).requiredEncryptionContextKeys()).UniqueElements(), true, ((_forall_var_17_boxed0) -> {
      dafny.DafnySequence<? extends java.lang.Byte> _forall_var_17 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_forall_var_17_boxed0));
      if (true) {
        dafny.DafnySequence<? extends java.lang.Byte> _1223_k = (dafny.DafnySequence<? extends java.lang.Byte>)_forall_var_17;
        return !(((this).requiredEncryptionContextKeys()).contains(_1223_k)) || ((((_1222_input).dtor_reproducedEncryptionContext()).dtor_value()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1223_k));
      } else {
        return true;
      }
    }))).apply(input), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Reproduced encryption context missing required keys.")));
    if ((_1221_valueOrError2).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1221_valueOrError2).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput _1224_result;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1225_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out220;
    _out220 = ((this).underlyingCMM()).DecryptMaterials(input);
    _1225_valueOrError3 = _out220;
    if ((_1225_valueOrError3).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1225_valueOrError3).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    _1224_result = (_1225_valueOrError3).Extract(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1226_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1226_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, Boolean>)(_1227_result) -> dafny.Helpers.Quantifier(((this).requiredEncryptionContextKeys()).UniqueElements(), true, ((_forall_var_18_boxed0) -> {
      dafny.DafnySequence<? extends java.lang.Byte> _forall_var_18 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_forall_var_18_boxed0));
      if (true) {
        dafny.DafnySequence<? extends java.lang.Byte> _1228_k = (dafny.DafnySequence<? extends java.lang.Byte>)_forall_var_18;
        return !(((this).requiredEncryptionContextKeys()).contains(_1228_k)) || ((((_1227_result).dtor_decryptionMaterials()).dtor_encryptionContext()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_1228_k));
      } else {
        return true;
      }
    }))).apply(_1224_result), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Final encryption context missing required keys.")));
    if ((_1226_valueOrError4).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1226_valueOrError4).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1229_valueOrError5 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1229_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), CMM_Compile.__default.EncryptionContextComplete(input, (_1224_result).dtor_decryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Reproduced encryption context missing from encryption context.")));
    if ((_1229_valueOrError5).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1229_valueOrError5).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1230_valueOrError6 = Wrappers_Compile.Outcome.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default();
    _1230_valueOrError6 = Wrappers_Compile.__default.<software.amazon.cryptography.materialproviders.internaldafny.types.Error>Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithPlaintextDataKey((_1224_result).dtor_decryptionMaterials()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(dafny.DafnySequence.asString("Keyring.OnDecrypt failed to decrypt the plaintext data key.")));
    if ((_1230_valueOrError6).IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
      output = (_1230_valueOrError6).<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput>PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput._typeDescriptor());
      return output;
    }
    output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_1224_result);
    return output;
  }
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager _underlyingCMM;
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager underlyingCMM()
  {
    return this._underlyingCMM;
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _requiredEncryptionContextKeys;
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> requiredEncryptionContextKeys()
  {
    return this._requiredEncryptionContextKeys;
  }
  private static final dafny.TypeDescriptor<RequiredEncryptionContextCMM> _TYPE = dafny.TypeDescriptor.<RequiredEncryptionContextCMM>referenceWithInitializer(RequiredEncryptionContextCMM.class, () -> (RequiredEncryptionContextCMM) null);
  public static dafny.TypeDescriptor<RequiredEncryptionContextCMM> _typeDescriptor() {
    return (dafny.TypeDescriptor<RequiredEncryptionContextCMM>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "RequiredEncryptionContextCMM.RequiredEncryptionContextCMM";
  }
}
