// Class StormTracker
// Dafny class StormTracker compiled into Java
package StormTracker_Compile;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;
import software.amazon.cryptography.keystore.internaldafny.*;
import AlgorithmSuites_Compile.*;
import Materials_Compile.*;
import Keyring_Compile.*;
import MultiKeyring_Compile.*;
import AwsKmsMrkAreUnique_Compile.*;
import Constants_Compile.*;
import MaterialWrapping_Compile.*;
import CanonicalEncryptionContext_Compile.*;
import IntermediateKeyWrapping_Compile.*;
import EdkWrapping_Compile.*;
import AwsKmsKeyring_Compile.*;
import StrictMultiKeyring_Compile.*;
import AwsKmsDiscoveryKeyring_Compile.*;
import DiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkDiscoveryKeyring_Compile.*;
import MrkAwareDiscoveryMultiKeyring_Compile.*;
import AwsKmsMrkKeyring_Compile.*;
import MrkAwareStrictMultiKeyring_Compile.*;
import LocalCMC_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class StormTracker {
  public StormTracker() {
    this.wrapped = null;
    this.inFlight = null;
    this.gracePeriod = 0L;
    this.graceInterval = 0L;
    this.fanOut = 0L;
    this.inFlightTTL = 0L;
    this.lastPrune = 0L;
    this.sleepMilli = 0L;
  }
  public LocalCMC_Compile.LocalCMC wrapped;
  public DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, java.lang.Long> inFlight;
  public long gracePeriod;
  public long graceInterval;
  public long fanOut;
  public long inFlightTTL;
  public long lastPrune;
  public long sleepMilli;
  public void __ctor(software.amazon.cryptography.materialproviders.internaldafny.types.StormTrackingCache cache)
  {
    LocalCMC_Compile.LocalCMC _nw31 = new LocalCMC_Compile.LocalCMC();
    _nw31.__ctor(java.math.BigInteger.valueOf(((cache).dtor_entryCapacity())), java.math.BigInteger.valueOf((((cache).dtor_entryPruningTailSize()).UnwrapOr(software.amazon.cryptography.materialproviders.internaldafny.types.CountingNumber._typeDescriptor(), 1))));
    (this).wrapped = _nw31;
    DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, java.lang.Long> _nw32 = new DafnyLibraries.MutableMap<dafny.DafnySequence<? extends java.lang.Byte>, java.lang.Long>(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.PositiveLong._typeDescriptor());
    (this).inFlight = _nw32;
    (this).gracePeriod = ((long) ((cache).dtor_gracePeriod()));
    (this).graceInterval = ((long) ((cache).dtor_graceInterval()));
    (this).fanOut = ((long) ((cache).dtor_fanOut()));
    (this).inFlightTTL = ((long) ((cache).dtor_inFlightTTL()));
    (this).sleepMilli = ((long) ((cache).dtor_sleepMilli()));
    (this).lastPrune = 0L;
  }
  public long InFlightSize() {
    java.math.BigInteger _800_x = (this.inFlight).Size();
    if ((_800_x).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) <= 0) {
      return (_800_x).longValue();
    } else {
      return (StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()).longValue();
    }
  }
  public boolean FanOutReached(long now)
  {
    boolean res = false;
    (this).PruneInFlight(now);
    res = (this.fanOut) <= ((this).InFlightSize());
    return res;
  }
  public long AddLong(long x, long y)
  {
    if ((x) < ((long)  (((StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()).longValue()) - (y)))) {
      return (long)  ((x) + (y));
    } else {
      return (StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()).longValue();
    }
  }
  public CacheState CheckInFlight(dafny.DafnySequence<? extends java.lang.Byte> identifier, software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput result, long now)
  {
    CacheState output = CacheState.Default();
    if(true) {
      boolean _801_fanOutReached;
      boolean _out129;
      _out129 = (this).FanOutReached(now);
      _801_fanOutReached = _out129;
      if (_801_fanOutReached) {
        output = StormTracker_Compile.CacheState.create_Full(result);
        return output;
      } else if (((result).dtor_expiryTime()) <= (now)) {
        CacheState _out130;
        _out130 = (this).CheckNewEntry(identifier, now);
        output = _out130;
      } else if ((now) < ((long)  (((result).dtor_expiryTime()) - (this.gracePeriod)))) {
        output = StormTracker_Compile.CacheState.create_Full(result);
        return output;
      } else {
        if ((this.inFlight).HasKey(identifier)) {
          long _802_entry;
          _802_entry = (this.inFlight).Select(identifier);
          if (((this).AddLong(_802_entry, this.graceInterval)) > (now)) {
            output = StormTracker_Compile.CacheState.create_Full(result);
            return output;
          }
        }
        (this.inFlight).Put(identifier, now);
        output = StormTracker_Compile.CacheState.create_EmptyFetch();
        return output;
      }
    }
    return output;
  }
  public void PruneInFlight(long now)
  {
    if ((this.fanOut) > ((this).InFlightSize())) {
      return;
    }
    if ((this.lastPrune) == (now)) {
      return;
    }
    (this).lastPrune = now;
    dafny.DafnySet<? extends dafny.DafnySequence<? extends java.lang.Byte>> _803_keySet;
    _803_keySet = (this.inFlight).Keys();
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _804_keys;
    _804_keys = SortedSets.__default.<dafny.DafnySequence<? extends java.lang.Byte>>SetToSequence(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), _803_keySet);
    java.math.BigInteger _hi7 = java.math.BigInteger.valueOf((_804_keys).length());
    for (java.math.BigInteger _805_i = java.math.BigInteger.ZERO; _805_i.compareTo(_hi7) < 0; _805_i = _805_i.add(java.math.BigInteger.ONE)) {
      long _806_v;
      _806_v = (this.inFlight).Select(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((_804_keys).select(dafny.Helpers.toInt((_805_i))))));
      if ((now) >= ((this).AddLong(_806_v, this.inFlightTTL))) {
        (this.inFlight).Remove(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((_804_keys).select(dafny.Helpers.toInt((_805_i))))));
      }
    }
  }
  public CacheState CheckNewEntry(dafny.DafnySequence<? extends java.lang.Byte> identifier, long now)
  {
    CacheState output = CacheState.Default();
    boolean _807_fanOutReached;
    boolean _out131;
    _out131 = (this).FanOutReached(now);
    _807_fanOutReached = _out131;
    if (_807_fanOutReached) {
      output = StormTracker_Compile.CacheState.create_EmptyWait();
      return output;
    } else if ((this.inFlight).HasKey(identifier)) {
      long _808_entry;
      _808_entry = (this.inFlight).Select(identifier);
      if (((this).AddLong(_808_entry, this.graceInterval)) > (now)) {
        output = StormTracker_Compile.CacheState.create_EmptyWait();
        return output;
      }
    }
    (this.inFlight).Put(identifier, now);
    output = StormTracker_Compile.CacheState.create_EmptyFetch();
    return output;
  }
  public Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetFromCacheWithTime(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input, long now)
  {
    Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(CacheState.Default());
    if(true) {
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _809_result;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out132;
      _out132 = (this.wrapped).GetCacheEntryWithTime(input, now);
      _809_result = _out132;
      if ((_809_result).is_Success()) {
        CacheState _810_newResult;
        CacheState _out133;
        _out133 = (this).CheckInFlight((input).dtor_identifier(), (_809_result).dtor_value(), now);
        _810_newResult = _out133;
        output = Wrappers_Compile.Result.<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_810_newResult);
        return output;
      } else if (((_809_result).dtor_error()).is_EntryDoesNotExist()) {
        CacheState _811_newResult;
        CacheState _out134;
        _out134 = (this).CheckNewEntry((input).dtor_identifier(), now);
        _811_newResult = _out134;
        output = Wrappers_Compile.Result.<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(_811_newResult);
        return output;
      } else {
        output = Wrappers_Compile.Result.<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure((_809_result).dtor_error());
        return output;
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetFromCache(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input)
  {
    Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(CacheState.Default());
    if(true) {
      long _812_now;
      long _out135;
      _out135 = Time.__default.CurrentRelativeTime();
      _812_now = _out135;
      Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out136;
      _out136 = (this).GetFromCacheWithTime(input, _812_now);
      output = _out136;
    }
    return output;
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput input)
  {
    Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = (Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>)null;
    if(true) {
      Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _813_result;
      Wrappers_Compile.Result<CacheState, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out137;
      _out137 = (this).GetFromCache(input);
      _813_result = _out137;
      if ((_813_result).is_Failure()) {
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure((_813_result).dtor_error());
        return output;
      } else if (((_813_result).dtor_value()).is_Full()) {
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Success(((_813_result).dtor_value()).dtor_data());
        return output;
      } else {
        output = Wrappers_Compile.Result.<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error>create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_EntryDoesNotExist(dafny.DafnySequence.asString("Entry does not exist")));
        return output;
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> PutCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if(true) {
      (this.inFlight).Remove((input).dtor_identifier());
      Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out138;
      _out138 = (this.wrapped).PutCacheEntry_k(input);
      output = _out138;
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DeleteCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if(true) {
      (this.inFlight).Remove((input).dtor_identifier());
      Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out139;
      _out139 = (this.wrapped).DeleteCacheEntry_k(input);
      output = _out139;
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> UpdateUsageMetadata(software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput input)
  {
    Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error>Default(dafny.Tuple0.Default());
    if(true) {
      Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out140;
      _out140 = (this.wrapped).UpdateUsageMetadata_k(input);
      output = _out140;
    }
    return output;
  }
  private static final dafny.TypeDescriptor<StormTracker> _TYPE = dafny.TypeDescriptor.<StormTracker>referenceWithInitializer(StormTracker.class, () -> (StormTracker) null);
  public static dafny.TypeDescriptor<StormTracker> _typeDescriptor() {
    return (dafny.TypeDescriptor<StormTracker>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "StormTracker.StormTracker";
  }
}
